/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.client;

import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.GameModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.LoginModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.WinModel;
import ch.unibas.dmi.dbis.cs108.example.protocol.Address;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChangeNickname;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChatContent;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameEndNotification;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameState;
import ch.unibas.dmi.dbis.cs108.example.protocol.LobbyInfo;
import ch.unibas.dmi.dbis.cs108.example.protocol.LoginMessage;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameClientNonBlocking {
    private static Timer serverReplyTimer = new Timer();
    private static GameClientNonBlocking instance;
    private final BlockingQueue<String> queueA = new LinkedBlockingQueue<String>();
    private final BlockingQueue<String> queueB = new LinkedBlockingQueue<String>();
    private final BlockingQueue<String> writerQueue = new LinkedBlockingQueue<String>();
    private final Address address;
    private Thread backgroundThread;

    public GameClientNonBlocking(Address address) {
        this.address = address;
    }

    public static void startPongTimer() {
        serverReplyTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                GameClientNonBlocking.shutdownClient();
            }
        }, 30000L);
    }

    public static void resetPongTimer() {
        serverReplyTimer.cancel();
        serverReplyTimer.purge();
        serverReplyTimer = new Timer();
    }

    private static void shutdownClient() {
        System.out.println("Server does not respond.");
        System.out.println("We are terminating this client.");
        Platform.runLater(Platform::exit);
        System.exit(0);
    }

    public static GameClientNonBlocking getInstance() {
        if (instance == null) {
            throw new IllegalStateException("GameClient has not yet been initialized. Please use GameClientNonBlocking.getInstance(Address address)");
        }
        return instance;
    }

    public static GameClientNonBlocking getInstance(Address address) {
        if (instance == null) {
            instance = new GameClientNonBlocking(address);
            instance.start();
        }
        return instance;
    }

    public void sendToServer(String message) {
        try {
            this.writerQueue.put(message);
        }
        catch (InterruptedException e) {
            System.err.println("Error sending message: " + e.getMessage());
        }
    }

    public void start() {
        this.backgroundThread = Thread.startVirtualThread(() -> {
            System.out.println("Starting Game Client...");
            try (Socket socket = new Socket(this.address.getHost(), (int)this.address.getPort());){
                OutputStream outputStream = socket.getOutputStream();
                Thread.startVirtualThread(new InputProxyThread(socket, this.queueA, this.queueB));
                Thread.startVirtualThread(new WorkerThread(this.queueA));
                Thread.startVirtualThread(new WorkerThread(this.queueB));
                Thread.startVirtualThread(new PingThread());
                Thread.startVirtualThread(new WriterThread(outputStream, this.writerQueue));
                this.handleUserInput(this.writerQueue);
            }
            catch (IOException e) {
                System.err.println("Error: " + e.getMessage());
            }
        });
    }

    private void handleUserInput(BlockingQueue<String> writerQueue) {
        try (BufferedReader consoleReader = new BufferedReader(new InputStreamReader(System.in));){
            String input;
            System.out.println("Enter messages (type 'QUIT' to exit):");
            while ((input = consoleReader.readLine()) != null) {
                if (input.equalsIgnoreCase("QUIT")) {
                    break;
                }
                writerQueue.put(input);
            }
        }
        catch (IOException | InterruptedException e) {
            System.err.println("Error while reading user input: " + e.getMessage());
        }
    }

    private static class InputProxyThread
    implements Runnable {
        private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
        private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");
        private final Socket socket;
        private final BlockingQueue<String> queueA;
        private final BlockingQueue<String> queueB;

        public InputProxyThread(Socket socket, BlockingQueue<String> queueA, BlockingQueue<String> queueB) {
            this.socket = socket;
            this.queueA = queueA;
            this.queueB = queueB;
        }

        @Override
        public void run() {
            GameClientNonBlocking.startPongTimer();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));){
                String message;
                while ((message = reader.readLine()) != null) {
                    LoginModel loginModel;
                    Object response;
                    Protocol p = new Protocol();
                    Protocol.ProtocolType type = p.parseProtocol(message);
                    if (type == Protocol.ProtocolType.LOGIN) {
                        response = p.parseLoginMessage(message);
                        generalLogger.info("[LOGIN] I am logged in with the name {}", (Object)((LoginMessage)response).getNickname());
                        loginModel = Model.getInstance().getLoginModel();
                        loginModel.setUsernameThreadSafe(((LoginMessage)response).getNickname());
                        continue;
                    }
                    if (type == Protocol.ProtocolType.CHAT) {
                        response = p.parseChat(message);
                        System.out.println(((ChatContent)response).getSender() + ": " + ((ChatContent)response).getMessage());
                        GameModel gameModel = Model.getInstance().getGameModel();
                        gameModel.addMessages(message);
                        continue;
                    }
                    if (type == Protocol.ProtocolType.PONG) {
                        System.out.println("Pong received");
                        GameClientNonBlocking.resetPongTimer();
                        GameClientNonBlocking.startPongTimer();
                        continue;
                    }
                    if (type == Protocol.ProtocolType.CHANGE_NICKNAME) {
                        response = p.parseChangeNickname(message);
                        generalLogger.info("[CHANGE_NICKNAME] Changing nickname from {} to {}", (Object)((ChangeNickname)response).getOldNickname(), (Object)((ChangeNickname)response).getNewNickname());
                        loginModel = Model.getInstance().getLoginModel();
                        loginModel.setUsernameThreadSafe(((ChangeNickname)response).getNewNickname());
                        continue;
                    }
                    if (type == Protocol.ProtocolType.GIVE_LOBBYINFO) {
                        LobbyInfo[] lobbyInfo = p.parseLobbyInfo(message);
                        loginModel = Model.getInstance().getLoginModel();
                        loginModel.addLobbiesToList(lobbyInfo);
                        generalLogger.info("[GIVE_LOBBYINFO] Client received: \n{}", (Object)p.encodeLobbyInfoGiver(lobbyInfo));
                        continue;
                    }
                    if (type == Protocol.ProtocolType.STATE) {
                        GameModel gameModel = Model.getInstance().getGameModel();
                        GameState gamestate = p.parseGameState(message);
                        gameModel.updateGameState(gamestate);
                        System.out.println("UPDATING GAMEISREADY");
                        continue;
                    }
                    if (type == Protocol.ProtocolType.LEADERBOARD) {
                        LoginModel loginModel2 = Model.getInstance().getLoginModel();
                        loginModel2.addLeaderBoard(p.parseLeaderBoard(message));
                        generalLogger.info("[LEADERBOARD] Client received: \n{}", (Object)message);
                        continue;
                    }
                    if (type == Protocol.ProtocolType.GAME_END_NOTIFICATION) {
                        WinModel winModel = Model.getInstance().getWinModel();
                        GameEndNotification notification = p.parseGameEndNotification(message);
                        winModel.changeToWinScreen(notification);
                        generalLogger.info("[GAME_END_NOTIFICATION] Client received: \n{}", (Object)message);
                        continue;
                    }
                    errorLogger.error("[Unknown protocol] An error occurred while processing the game: {}", (Object)message);
                }
            }
            catch (IOException e) {
                errorLogger.error("The server has been terminated");
            }
        }
    }

    private static class WorkerThread
    implements Runnable {
        private final BlockingQueue<String> queue;
        private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
        private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");

        public WorkerThread(BlockingQueue<String> queue) {
            this.queue = queue;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    String message = this.queue.take();
                    System.out.println(Thread.currentThread().getName() + " processed message: " + message);
                    generalLogger.info("[WorkerThread] {} processed message: {}", (Object)Thread.currentThread().getName(), (Object)message);
                }
            }
            catch (InterruptedException e) {
                errorLogger.error("[WorkerThread] WorkerThread interrupted: {}", (Object)e.getMessage());
                return;
            }
        }
    }

    private static class PingThread
    implements Runnable {
        private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");

        private PingThread() {
        }

        @Override
        public void run() {
            while (true) {
                GameClientNonBlocking.getInstance().sendToServer("PING;");
                System.out.println("Ping has been sent");
                try {
                    Thread.sleep(7000L);
                    continue;
                }
                catch (Exception e) {
                    errorLogger.error("[PingThread] interrupted: {}", (Object)e.getMessage());
                    continue;
                }
                break;
            }
        }
    }

    private static class WriterThread
    implements Runnable {
        private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
        private final OutputStream outputStream;
        private final BlockingQueue<String> writerQueue;

        public WriterThread(OutputStream outputStream, BlockingQueue<String> writerQueue) {
            this.outputStream = outputStream;
            this.writerQueue = writerQueue;
        }

        @Override
        public void run() {
            try {
                PrintWriter writer = new PrintWriter(this.outputStream, true);
                try {
                    while (true) {
                        String message = this.writerQueue.take();
                        writer.println(message);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException e) {
                errorLogger.error("[WriterThread] interrupted: {}", (Object)e.getMessage());
                return;
            }
        }
    }
}

