/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gameLogic;

import java.util.Vector;

public class Card {
    Sign sign;
    Value value;

    public boolean isOutOfHouseCard() {
        return this.value == Value.KING || this.value == Value.ACE;
    }

    public boolean isJokerCard() {
        return this.value == Value.JOKERVALUE;
    }

    public boolean isSwapCard() {
        return this.value == Value.JACK;
    }

    public boolean isFoldingCard() {
        return this.value == Value.NULLVALUE || this.sign == Sign.NULLSIGN;
    }

    public Integer moves() {
        return switch (this.value.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> 1;
            case 12 -> 1;
            case 11 -> 12;
            case 10 -> 1;
            case 9 -> 10;
            case 8 -> 9;
            case 7 -> 8;
            case 6 -> 7;
            case 1 -> 2;
            case 2 -> 3;
            case 3 -> 4;
            case 4 -> 5;
            case 5 -> 6;
            case 13 -> 1;
            case 14 -> 0;
        };
    }

    public Card(Sign sign, Value value) {
        this.sign = sign;
        this.value = value;
    }

    public Value getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    public boolean isSeven() {
        return this.value == Value.SEVEN;
    }

    public static Vector<Card> createCardDeck() {
        Vector<Card> deck = new Vector<Card>();
        for (Sign s : Sign.values()) {
            if (s == Sign.NULLSIGN || s == Sign.JOKERSIGNRED) continue;
            for (Value v : Value.values()) {
                if (v == Value.NULLVALUE || v == Value.JOKERVALUE) continue;
                deck.add(new Card(s, v));
            }
        }
        for (int j = 0; j < 4; ++j) {
            deck.add(new Card(Sign.JOKERSIGNRED, Value.JOKERVALUE));
        }
        return deck;
    }

    public String toString() {
        return this.sign.toString() + ":" + this.value.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Card card = (Card)obj;
        return this.sign == card.sign && this.value == card.value;
    }

    public static enum Value {
        ACE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE,
        TEN,
        JACK,
        QUEEN,
        KING,
        JOKERVALUE,
        NULLVALUE;

    }

    public static enum Sign {
        SPADE,
        HEART,
        CLUB,
        DIAMOND,
        JOKERSIGNRED,
        NULLSIGN;

    }
}

