/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gameLogic;

import ch.unibas.dmi.dbis.cs108.example.MathHelper;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Card;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.CardDeck;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.CardsPerRoundTracker;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Hand;
import ch.unibas.dmi.dbis.cs108.example.protocol.CheatMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigureMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigurePositions;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameEndNotification;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameState;
import ch.unibas.dmi.dbis.cs108.example.protocol.JackMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.JokerMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.LobbyInfo;
import ch.unibas.dmi.dbis.cs108.example.protocol.Move;
import ch.unibas.dmi.dbis.cs108.example.protocol.MoveWithMetaInformation;
import ch.unibas.dmi.dbis.cs108.example.protocol.SevenMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.TradeMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import ch.unibas.dmi.dbis.cs108.example.server.LeaderBoardManager;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Game {
    private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");
    private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
    LeaderBoardManager leaderBoardManager;
    Integer id;
    User[] players;
    User turn;
    FigurePositions[] figurePositions;
    Hand[] playerHands;
    GameState.Phase phase;
    private int turnCounter = 0;
    CardsPerRoundTracker cardTracker = new CardsPerRoundTracker();
    Optional<Integer> winnerOfTheGame = Optional.empty();
    Optional<User[]> preemptiveWinner = Optional.empty();
    CardDeck cards;
    private final Card[] pendingTradeCards = new Card[4];
    private int tradeMovesReceived = 0;
    Vector<User> waitingUsers = new Vector();
    boolean isActive = true;
    boolean usersHaveBeenKicked = false;
    private static int countFields = 96;
    static int player1StartPos = 32;
    static int player2StartPos = player1StartPos + 16;
    static int player3StartPos = player2StartPos + 16;
    static int player4StartPos = player3StartPos + 16;
    static int[] playerStartPositions = new int[]{player1StartPos, player2StartPos, player3StartPos, player4StartPos};
    static int player1BankPos = 16;
    static int player2BankPos = player1BankPos + 4;
    static int player3BankPos = player2BankPos + 4;
    static int player4BankPos = player3BankPos + 4;
    static int[] playerBankPositions = new int[]{player1BankPos, player2BankPos, player3BankPos, player4BankPos};
    static int player1GoalPos = 0;
    static int player2GoalPos = player1GoalPos + 4;
    static int player3GoalPos = player2GoalPos + 4;
    static int player4GoalPos = player3GoalPos + 4;
    static int[] playerGoalPositions = new int[]{player1GoalPos, player2GoalPos, player3GoalPos, player4GoalPos};
    static Integer[] goalEntryPositions = new Integer[]{95, player2StartPos - 1, player3StartPos - 1, player4StartPos - 1};

    public Game(Integer gameId, LeaderBoardManager leaderBoardManager) {
        this.isActive = false;
        this.id = gameId;
        this.leaderBoardManager = leaderBoardManager;
    }

    public void setUsersKicked() {
        this.usersHaveBeenKicked = true;
    }

    public boolean usersHaveBeenKicked() {
        return this.usersHaveBeenKicked;
    }

    public Integer numberOfPlayers() {
        return this.waitingUsers.size();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isFinished() {
        return this.winnerOfTheGame.isPresent() || this.preemptiveWinner.isPresent();
    }

    public void setGamePreemptivelyFinished() {
        this.isActive = true;
        this.preemptiveWinner = Optional.of(new User[]{new User("Niemand"), new User("hat"), new User("gewonnen"), new User("leider")});
    }

    public void addWaitingPlayer(String nickname) {
        this.waitingUsers.add(new User(nickname));
    }

    public void startGame() {
        if (this.waitingUsers.size() != 4) {
            throw new IllegalArgumentException("The number of players must be 4");
        }
        this.turnCounter = 0;
        this.isActive = true;
        if (this.players == null) {
            this.players = (User[])this.waitingUsers.toArray(User[]::new);
        }
        this.setTurn(this.players[0]);
        FigurePositions[] positions = new FigurePositions[4];
        for (int playerIndex = 0; playerIndex < this.players.length; ++playerIndex) {
            Integer[] playerStartPositions = new Integer[]{playerBankPositions[playerIndex], playerBankPositions[playerIndex] + 1, playerBankPositions[playerIndex] + 2, playerBankPositions[playerIndex] + 3};
            positions[playerIndex] = new FigurePositions(this.players[playerIndex], playerStartPositions);
        }
        this.figurePositions = positions;
        this.cards = new CardDeck();
        this.givePlayersNewHandsAndStartTradePhase();
    }

    public Game(Integer gameId, String[] players) {
        this.id = gameId;
        this.players = (User[])Arrays.stream(players).map(User::new).toArray(User[]::new);
        this.waitingUsers = Arrays.stream(players).map(User::new).collect(Collectors.toCollection(Vector::new));
        this.startGame();
    }

    public int getWaitingUsersCount() {
        return this.waitingUsers.size();
    }

    private void givePlayersNewHandsAndStartTradePhase() {
        Hand[] playerHands = new Hand[4];
        Integer amountOfCardsForUpcomingRound = this.cardTracker.getCurrentCardsPerRound();
        for (int playerIndex = 0; playerIndex < this.players.length; ++playerIndex) {
            Card[] playerCards = (Card[])IntStream.range(0, amountOfCardsForUpcomingRound).mapToObj(i -> this.cards.popRandomCard()).toArray(Card[]::new);
            playerHands[playerIndex] = new Hand(this.players[playerIndex], playerCards);
        }
        this.cardTracker.decreaseCardsForNextRound();
        this.playerHands = playerHands;
        this.resetTradeState();
        this.phase = GameState.Phase.TRADE;
    }

    private void resetTradeState() {
        this.tradeMovesReceived = 0;
        Arrays.fill(this.pendingTradeCards, null);
    }

    private void givePlayersNewHands() {
        Hand[] playerHands = new Hand[4];
        for (int playerIndex = 0; playerIndex < this.players.length; ++playerIndex) {
            Card[] playerCards = new Card[]{this.cards.popRandomCard(), this.cards.popRandomCard(), this.cards.popRandomCard(), this.cards.popRandomCard(), this.cards.popRandomCard(), this.cards.popRandomCard()};
            playerHands[playerIndex] = new Hand(this.players[playerIndex], playerCards);
        }
        this.playerHands = playerHands;
    }

    private GameState handleTradePhase(MoveWithMetaInformation moveOperation) {
        if (!this.isTradeMove(moveOperation)) {
            errorLogger.warn("[GAME] Received non-TradeMove during TRADE phase from {}. Ignoring.", (Object)moveOperation.getNickname());
            return this.getGameState();
        }
        TradeMove tradeMove = (TradeMove)moveOperation.getMoveOperation();
        User submittingPlayer = new User(moveOperation.getNickname());
        int playerIndex = -1;
        for (int t = 0; t < this.players.length; ++t) {
            if (!this.players[t].equals(submittingPlayer)) continue;
            playerIndex = t;
            break;
        }
        if (playerIndex == -1) {
            errorLogger.error("[GAME] Could not find player {}", (Object)submittingPlayer);
        }
        if (this.pendingTradeCards[playerIndex] != null) {
            generalLogger.warn("[GAME] Player {} already submitted a trade card. Ignoring duplicate.", (Object)submittingPlayer.getNickname());
        }
        Hand playerHand = this.getPlayerHand(playerIndex);
        if (!playerHand.cards.contains(tradeMove.card)) {
            errorLogger.warn("[GAME] Player {} tried to trade card {} which they don't have. Ignoring.", (Object)submittingPlayer.getNickname(), (Object)tradeMove.card);
            return this.getGameState();
        }
        this.pendingTradeCards[playerIndex] = tradeMove.card;
        ++this.tradeMovesReceived;
        if (this.tradeMovesReceived == 4) {
            generalLogger.info("[GAME] All 4 trade cards received. Executing trade.");
            this.executeTrade();
            this.phase = GameState.Phase.PLAY;
            this.setTurn(this.players[0]);
            generalLogger.info("[GAME] Trade complete. Entering PLAY phase. Player {}'s turn.", (Object)this.turn.getNickname());
            return this.getGameState();
        }
        int currentPlayerIndex = Arrays.asList(this.players).indexOf(this.turn);
        this.switchToNextPlayer(currentPlayerIndex);
        return this.getGameState();
    }

    private void executeTrade() {
        Card card0 = this.pendingTradeCards[0];
        Card card1 = this.pendingTradeCards[1];
        Card card2 = this.pendingTradeCards[2];
        Card card3 = this.pendingTradeCards[3];
        boolean removed0 = this.playerHands[0].cards.remove(card0);
        boolean removed2 = this.playerHands[2].cards.remove(card2);
        if (!removed0) {
            errorLogger.error("Failed to remove {} from player 0 hand during trade", (Object)card0);
        }
        if (!removed2) {
            errorLogger.error("Failed to remove {} from player 2 hand during trade", (Object)card2);
        }
        this.playerHands[0].cards.add(card2);
        this.playerHands[2].cards.add(card0);
        generalLogger.debug("[GAME] Trade: Player 0 gave {} got {}, Player 2 gave {} got {}", (Object)card0, (Object)card2, (Object)card2, (Object)card0);
        boolean removed1 = this.playerHands[1].cards.remove(card1);
        boolean removed3 = this.playerHands[3].cards.remove(card3);
        if (!removed1) {
            errorLogger.error("Failed to remove {} from player 1 hand during trade", (Object)card1);
        }
        if (!removed3) {
            errorLogger.error("Failed to remove {} from player 3 hand during trade", (Object)card3);
        }
        this.playerHands[1].cards.add(card3);
        this.playerHands[3].cards.add(card1);
        generalLogger.debug("[GAME] Trade: Player 1 gave {} got {}, Player 3 gave {} got {}", (Object)card1, (Object)card3, (Object)card3, (Object)card1);
        this.resetTradeState();
    }

    public GameState proceedGame(MoveWithMetaInformation moveOperation) {
        if (moveOperation == null) {
            generalLogger.info("[GAME] MoveOperation is null");
            return this.getGameState();
        }
        if (this.winnerOfTheGame.isPresent()) {
            generalLogger.info("[GAME] Game is already won");
            return this.getGameState();
        }
        if (this.phase.equals((Object)GameState.Phase.TRADE)) {
            return this.handleTradePhase(moveOperation);
        }
        if (!this.currentPlayersTurn(moveOperation)) {
            generalLogger.info("[GAME] MoveOperation is not from current turn");
            return this.getGameState();
        }
        int currentPlayerIndex = Arrays.asList(this.players).indexOf(this.turn);
        if (this.isACheatingOne(moveOperation)) {
            generalLogger.info("[GAME] Cheat move");
            this.bringGameIntoWinningCondition(currentPlayerIndex);
            return this.getGameState();
        }
        if (this.isSkipping(moveOperation)) {
            generalLogger.info("[GAME] Skipping move");
            this.removeAllCardFromUser(currentPlayerIndex);
            this.switchToNextPlayer(currentPlayerIndex);
            return this.getGameState();
        }
        if (this.isJokerMove(moveOperation)) {
            JokerMove move = (JokerMove)moveOperation.getMoveOperation();
            generalLogger.info("[GAME] JokerMove");
            if (!this.playerHasAJoker(currentPlayerIndex)) {
                generalLogger.error("[GAME] JokerMove invalid, as Player does not have a Joker! - sending old game state");
                return this.getGameState();
            }
            Hand playerHand = this.getPlayerHand(currentPlayerIndex);
            playerHand.swapJokerWithCard(move.card);
            return this.getGameState();
        }
        if (!this.operationIsValid(this.figurePositions, moveOperation.getMoveOperation())) {
            generalLogger.info("[GAME] MoveOperation is not valid - sending old game state");
            return this.getGameState();
        }
        Card card = moveOperation.getMoveOperation().card;
        if (card.isSwapCard()) {
            if (!this.isJackMove(moveOperation)) {
                errorLogger.error("[GAME] We expect a JackMove here! - sending old game state");
                return this.getGameState();
            }
            JackMove move = (JackMove)moveOperation.getMoveOperation();
            int ownFigure = move.figure;
            int otherFigure = move.otherFigure;
            if (this.figureIsInGoalOrBank(ownFigure) || this.figureIsInGoalOrBank(otherFigure)) {
                errorLogger.error("[GAME] JackMove: Either of the figures is in bank or goal field - sending old game state");
                return this.getGameState();
            }
            Optional<Integer> optional = this.maybeFigureIndex(ownFigure, currentPlayerIndex);
            Optional<Pair<Integer, Integer>> maybeOtherPlayerIndexAndFigureIndex = this.getPlayerIndexFigureIndex(otherFigure);
            if (optional.isEmpty() || maybeOtherPlayerIndexAndFigureIndex.isEmpty()) {
                errorLogger.error("[GAME] JackMove: Either of the figures does not exist! - sending old game state");
                return this.getGameState();
            }
            if (this.figureIsOnStartingField(ownFigure, currentPlayerIndex) || this.figureIsOnStartingField(otherFigure, maybeOtherPlayerIndexAndFigureIndex.get().getKey())) {
                errorLogger.error("[GAME] JackMove: One of the figures is on their starting field! - sending old game state");
                return this.getGameState();
            }
            this.getPlayerFigurePositions((int)currentPlayerIndex)[optional.get().intValue()] = otherFigure;
            this.getPlayerFigurePositions((int)maybeOtherPlayerIndexAndFigureIndex.get().getKey().intValue())[maybeOtherPlayerIndexAndFigureIndex.get().getValue().intValue()] = ownFigure;
        } else {
            Vector<Object> figurePosWithMoves = new Vector();
            Move otherFigure = moveOperation.getMoveOperation();
            if (otherFigure instanceof SevenMove) {
                SevenMove sevenMove = (SevenMove)otherFigure;
                figurePosWithMoves = sevenMove.getFigureMoves();
                Integer sumMovesSeven = figurePosWithMoves.stream().map(f -> f.moves).reduce(0, Integer::sum);
                if (sumMovesSeven != 7) {
                    errorLogger.error("[GAME] SevenMove: Not Seven moves! - sending old game state");
                    return this.getGameState();
                }
            } else {
                Integer desiredMoves = moveOperation.getMoveOperation().desiredMoves().orElse(card.moves());
                figurePosWithMoves.add(new FigureMove(moveOperation.getMoveOperation().figure, desiredMoves));
            }
            Vector<MoveResult> computedMoveResults = new Vector<MoveResult>();
            for (FigureMove figureMove : figurePosWithMoves) {
                Optional<MoveResult> moveResult = this.movePlayer(card, figureMove.figurePosition, figureMove.moves, currentPlayerIndex);
                if (moveResult.isEmpty()) {
                    errorLogger.error("[GAME] The move is not valid - sending old game state!");
                    return this.getGameState();
                }
                computedMoveResults.add(moveResult.get());
            }
            for (MoveResult moveResult : computedMoveResults) {
                if (card.isSeven()) {
                    this.burnPlayers(moveResult, playerBankPositions, this.figurePositions);
                } else {
                    this.kickOtherPlayer(moveResult.resultingPosition, playerBankPositions, this.figurePositions);
                }
                this.getPlayerFigurePositions((int)currentPlayerIndex)[moveResult.figureIndex.intValue()] = moveResult.resultingPosition;
            }
        }
        if (this.gameIsOver()) {
            if (this.leaderBoardManager != null) {
                this.leaderBoardManager.recordWin(this.players[currentPlayerIndex], this.turnCounter);
                int allyIndex = (currentPlayerIndex + 2) % this.players.length;
                this.leaderBoardManager.recordWin(this.players[allyIndex], this.turnCounter);
            }
            this.winnerOfTheGame = Optional.of(currentPlayerIndex);
            return this.getGameState();
        }
        this.removeCardFromUser(this.playerHands, currentPlayerIndex, card);
        this.switchToNextPlayer(currentPlayerIndex);
        return this.getGameState();
    }

    private Optional<MoveResult> movePlayer(Card card, Integer figurePos, Integer moves, Integer playerIndex) {
        Optional<Integer> maybeFigureIndex = this.maybeFigureIndex(figurePos, playerIndex);
        if (maybeFigureIndex.isEmpty()) {
            errorLogger.error("[GAME] Someone gave a figure in the move, that does not exist!");
            return Optional.empty();
        }
        Integer currentFigureIndex = maybeFigureIndex.get();
        Optional<Integer> resultFigurePos = this.computeResultingFigurePosition(card, moves, playerIndex, figurePos);
        if (resultFigurePos.isEmpty()) {
            return Optional.empty();
        }
        if (resultFigurePos.get() < 0 || resultFigurePos.get() > 95) {
            this.errorReportGameStateAndPlayerIntend("[GAME] Invalid Index - the resulting figurepos cannot be negative, or greater 95!", card, moves, playerIndex, figurePos);
        }
        return Optional.of(new MoveResult(this, resultFigurePos.get(), figurePos, currentFigureIndex, moves, playerIndex));
    }

    private void bringGameIntoWinningCondition(Integer currentPlayerIndex) {
        for (int figureIndex = 1; figureIndex < 4; ++figureIndex) {
            this.figurePositions[currentPlayerIndex.intValue()].pos[figureIndex] = this.playerGoalPositions(currentPlayerIndex).get(figureIndex);
        }
        int allyIndex = (currentPlayerIndex + 2) % this.players.length;
        for (int figureIndex = 0; figureIndex < 4; ++figureIndex) {
            this.figurePositions[allyIndex].pos[figureIndex] = this.playerGoalPositions(allyIndex).get(figureIndex);
        }
        this.figurePositions[currentPlayerIndex.intValue()].pos[0] = goalEntryPositions[currentPlayerIndex] - 1;
        for (int playerIndex = 0; playerIndex < this.players.length; ++playerIndex) {
            this.playerHands[playerIndex].cards = new Vector();
        }
        this.playerHands[currentPlayerIndex.intValue()].cards.add(new Card(Card.Sign.DIAMOND, Card.Value.TWO));
    }

    private boolean isACheatingOne(MoveWithMetaInformation moveOperation) {
        return moveOperation.getMoveOperation() instanceof CheatMove;
    }

    private boolean isJokerMove(MoveWithMetaInformation moveOperation) {
        return moveOperation.getMoveOperation() instanceof JokerMove;
    }

    private boolean isJackMove(MoveWithMetaInformation moveOperation) {
        return moveOperation.getMoveOperation() instanceof JackMove;
    }

    private boolean isTradeMove(MoveWithMetaInformation moveOperation) {
        return moveOperation.getMoveOperation() instanceof TradeMove;
    }

    private boolean playerHasAJoker(int playerIndex) {
        return this.getPlayerHand(playerIndex).hasJoker();
    }

    private Hand getPlayerHand(int playerIndex) {
        return this.playerHands[playerIndex];
    }

    private Integer[] getPlayerFigurePositions(int currentPlayerIndex) {
        return this.figurePositions[currentPlayerIndex].pos;
    }

    private boolean figureIsInGoalOrBank(int figurePos) {
        return figurePos <= player4BankPos + 4;
    }

    private boolean figureIsOnStartingField(int figurePos, int playerIndex) {
        return figurePos == playerStartPositions[playerIndex];
    }

    private Optional<Integer> maybeFigureIndex(int figurePos, int playerIndex) {
        Integer[] positions = this.getPlayerFigurePositions(playerIndex);
        return IntStream.range(0, 4).filter(index -> positions[index] == figurePos).boxed().findFirst();
    }

    private Optional<Pair<Integer, Integer>> getPlayerIndexFigureIndex(Integer figurePos) {
        for (int playerIndex = 0; playerIndex < 4; ++playerIndex) {
            Optional<Integer> maybeFigureIndex = this.maybeFigureIndex(figurePos, playerIndex);
            if (!maybeFigureIndex.isPresent()) continue;
            return Optional.of(new Pair<Integer, Integer>(playerIndex, maybeFigureIndex.get()));
        }
        return Optional.empty();
    }

    Optional<Integer> getPlayerIndex(String playerName) {
        return Arrays.stream(this.players).filter(user -> user.getNickname().equals(playerName)).findFirst().map(user -> Arrays.asList(this.players).indexOf(user));
    }

    private void switchToNextPlayer(int currentPlayerIndex) {
        int nextPlayerIndex = (currentPlayerIndex + 1) % this.players.length;
        for (int playersChecked = 0; playersChecked < this.players.length; ++playersChecked) {
            if (!this.getPlayerHand((int)nextPlayerIndex).cards.isEmpty()) {
                this.setTurn(this.players[nextPlayerIndex]);
                return;
            }
            nextPlayerIndex = (nextPlayerIndex + 1) % this.players.length;
        }
        this.givePlayersNewHandsAndStartTradePhase();
        nextPlayerIndex = (currentPlayerIndex + 1) % this.players.length;
        this.setTurn(this.players[nextPlayerIndex]);
        ++this.turnCounter;
    }

    public Optional<User> getWinnerOfGame() {
        return this.winnerOfTheGame.map(winnerIndex -> this.players[winnerIndex]);
    }

    private void removeAllCardFromUser(Integer currentUserIndex) {
        this.playerHands[currentUserIndex.intValue()].cards = new Vector();
    }

    private void removeCardFromUser(Hand[] playerHands, Integer currentUserIndex, Card usedCard) {
        if (usedCard.isSeven()) {
            Optional<Card> maybeCard = playerHands[currentUserIndex.intValue()].cards.stream().filter(card -> card.isSeven()).findFirst();
            if (maybeCard.isEmpty()) {
                errorLogger.error("[GAME] SevenCard was removed, but no seven card was present!");
                throw new RuntimeException("[GAME] SevenCard was removed, but no seven card was present!");
            }
            usedCard = maybeCard.get();
        }
        Card cardToBeRemoved = usedCard;
        playerHands[currentUserIndex.intValue()].cards = playerHands[currentUserIndex.intValue()].cards.stream().filter(card -> !card.equals(cardToBeRemoved)).collect(Collectors.toCollection(Vector::new));
    }

    private List<Integer> playerGoalPositions(Integer playerIndex) {
        return Arrays.asList(playerGoalPositions[playerIndex], playerGoalPositions[playerIndex] + 1, playerGoalPositions[playerIndex] + 2, playerGoalPositions[playerIndex] + 3);
    }

    private boolean isSkipping(MoveWithMetaInformation move) {
        return move.getMoveOperation().card.getValue() == Card.Value.NULLVALUE;
    }

    private boolean playerHasAllFiguresInGoal(int playerIndex) {
        return Arrays.stream(this.figurePositions[playerIndex].pos).allMatch(pos -> this.playerGoalPositions(playerIndex).contains(pos));
    }

    private boolean gameIsOver() {
        for (int playerIndex = 0; playerIndex < this.players.length; ++playerIndex) {
            int allyIndex;
            if (!this.playerHasAllFiguresInGoal(playerIndex) || !this.playerHasAllFiguresInGoal(allyIndex = (playerIndex + 2) % this.players.length)) continue;
            return true;
        }
        return false;
    }

    private boolean currentPlayersTurn(MoveWithMetaInformation moveOperation) {
        return moveOperation.getNickname().equals(this.turn.getNickname());
    }

    private static boolean startsFromBank(int figurePos) {
        return player1BankPos <= figurePos && figurePos < player4BankPos + 4;
    }

    private boolean figureInsideGoal(int figurePos) {
        return figurePos < player4GoalPos + 4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Optional<Integer> computeResultingFigurePosition(Card card, Integer desiredMoves, int currentPlayerIndex, int figurePos) {
        Optional<Integer> resultFigurePos = Optional.empty();
        if (Game.startsFromBank(figurePos)) {
            if (!card.isOutOfHouseCard()) return Optional.empty();
            return Optional.of(playerStartPositions[currentPlayerIndex]);
        }
        if (!this.figureInsideGoal(figurePos)) return Optional.of(this.canMoveIntoHouse(playerGoalPositions[currentPlayerIndex], goalEntryPositions[currentPlayerIndex], figurePos, this.figurePositions[currentPlayerIndex].pos, desiredMoves).orElse(MathHelper.wrapPosition(figurePos, desiredMoves, player1StartPos, countFields)));
        if (figurePos + desiredMoves >= playerGoalPositions[currentPlayerIndex] + 4) {
            return Optional.empty();
        }
        if (desiredMoves < 0) {
            return Optional.empty();
        }
        int currentFigurePos = figurePos;
        Integer[] playerFiguresInGoalAndInFront = (Integer[])Arrays.stream(this.figurePositions[currentPlayerIndex].pos).filter(pos -> pos < player4GoalPos + 4).filter(figures -> figures > currentFigurePos).toArray(Integer[]::new);
        if (playerFiguresInGoalAndInFront.length == 0) {
            return Optional.of(currentFigurePos + desiredMoves);
        }
        Optional<Integer> smallestDistanceToNextFigure = Arrays.stream(playerFiguresInGoalAndInFront).map(otherFigure -> otherFigure - currentFigurePos).min(Integer::compareTo);
        if (!smallestDistanceToNextFigure.isPresent()) return resultFigurePos;
        if (desiredMoves >= smallestDistanceToNextFigure.get()) return resultFigurePos;
        return Optional.of(currentFigurePos + desiredMoves);
    }

    private void errorReportGameStateAndPlayerIntend(String message, Card card, Integer desiredMoves, int currentPlayerIndex, int figurePos) {
        errorLogger.error(message);
        errorLogger.error("[GAME] Gamestate:" + this.getGameState().toString());
        errorLogger.error("[GAME] Player desiredMoved: " + desiredMoves);
        errorLogger.error("[GAME] Player figurePosition: " + figurePos);
        errorLogger.error("[GAME] Player index:" + currentPlayerIndex);
        errorLogger.error("[GAME] Player card:" + card.toString());
    }

    private Optional<Integer> canMoveIntoHouse(Integer firstGoalPos, Integer goalEntryPos, Integer currentFigure, Integer[] playerFigures, Integer desiredMoves) {
        if (currentFigure > goalEntryPos) {
            return Optional.empty();
        }
        Integer movesAfterHouseEntryPos = currentFigure + desiredMoves - goalEntryPos;
        if (movesAfterHouseEntryPos <= 0) {
            return Optional.empty();
        }
        Integer movesFreeInHouse = this.freeFieldsUntilFirstHousingFigure(playerFigures, firstGoalPos);
        if (movesAfterHouseEntryPos > movesFreeInHouse) {
            return Optional.empty();
        }
        Integer movesInHouse = movesAfterHouseEntryPos - 1;
        return Optional.of(firstGoalPos + movesInHouse);
    }

    private Integer freeFieldsUntilFirstHousingFigure(Integer[] playerFigures, Integer firstGoalPos) {
        return Arrays.stream(playerFigures).filter(figure -> figure < player4GoalPos + 4).min(Integer::compareTo).map(smallestValue -> smallestValue - firstGoalPos).orElse(4);
    }

    private void kickOtherPlayer(int resultFigurePos, int[] bankPositions, FigurePositions[] figurePositions) {
        boolean throwOut = false;
        for (int playerIndex = 0; playerIndex < 4 && !throwOut; ++playerIndex) {
            Integer[] figures = figurePositions[playerIndex].pos;
            for (int figureIndex = 0; figureIndex < 4; ++figureIndex) {
                int startingBankPos;
                if (figures[figureIndex] != resultFigurePos) continue;
                for (int bankPos = startingBankPos = bankPositions[playerIndex]; bankPos < startingBankPos + 4; ++bankPos) {
                    if (Arrays.asList(figures).contains(bankPos)) continue;
                    figures[figureIndex] = bankPos;
                    throwOut = true;
                }
            }
        }
    }

    private void burnPlayers(MoveResult moveRes, int[] bankPositions, FigurePositions[] figurePositions) {
        Integer startPos = moveRes.positionBeforeMove;
        Integer endPos = moveRes.resultingPosition;
        for (int playerIndex = 0; playerIndex < 4; ++playerIndex) {
            Integer[] figures = figurePositions[playerIndex].pos;
            if (playerIndex == moveRes.playerIndex) continue;
            block1: for (int figureIndex = 0; figureIndex < 4; ++figureIndex) {
                int startingBankPos;
                if (figures[figureIndex] < player4BankPos + 4) continue;
                if (MathHelper.isBetween(endPos, playerGoalPositions[moveRes.playerIndex], playerGoalPositions[moveRes.playerIndex] + 3) && !MathHelper.isBetween(startPos, playerGoalPositions[moveRes.playerIndex], playerGoalPositions[moveRes.playerIndex] + 3)) {
                    endPos = goalEntryPositions[moveRes.playerIndex];
                }
                if (!MathHelper.isBetween(figures[figureIndex], startPos, endPos)) continue;
                for (int bankPos = startingBankPos = bankPositions[playerIndex]; bankPos < startingBankPos + 4; ++bankPos) {
                    if (Arrays.asList(figures).contains(bankPos)) continue;
                    figures[figureIndex] = bankPos;
                    continue block1;
                }
            }
        }
    }

    public boolean operationIsValid(FigurePositions[] figurePositions, Move move) {
        int figure = move.figure;
        Card card = move.card;
        boolean startingPosition = Game.startsFromBank(figure);
        if (startingPosition) {
            return card.isOutOfHouseCard();
        }
        return true;
    }

    public GameState getGameState() {
        return new GameState(this.players, this.turn, this.phase, this.figurePositions, this.playerHands);
    }

    public void setTurn(User user) {
        this.turn = user;
    }

    private void log(String message) {
        System.out.println("[GAME]: " + message);
    }

    public String[] getPlayerNicknames() {
        if (this.isFinished() || !this.isActive()) {
            return (String[])this.waitingUsers.stream().map(User::getNickname).toArray(String[]::new);
        }
        return (String[])Arrays.stream(this.players).map(User::getNickname).toArray(String[]::new);
    }

    public int getLobbyID() {
        return this.id;
    }

    public void setWinnerOfGame(int winningIndex) {
        this.winnerOfTheGame = Optional.of(winningIndex);
    }

    public Optional<GameEndNotification> createGameEndNotification() {
        if (this.winnerOfTheGame.isEmpty() && this.preemptiveWinner.isEmpty()) {
            return Optional.empty();
        }
        User[] winners = new User[]{};
        User[] losers = new User[]{};
        if (this.winnerOfTheGame.isPresent()) {
            int winnerIndex = this.winnerOfTheGame.get();
            winners = new User[]{this.players[winnerIndex], this.players[(winnerIndex + 2) % 4]};
            losers = new User[]{this.players[(winnerIndex + 1) % 4], this.players[(winnerIndex + 3) % 4]};
        }
        if (this.preemptiveWinner.isPresent()) {
            User[] fictiveUsers = this.preemptiveWinner.get();
            winners = Arrays.copyOfRange(fictiveUsers, 0, 2);
            losers = Arrays.copyOfRange(fictiveUsers, 2, 4);
        }
        return Optional.of(new GameEndNotification(winners, losers));
    }

    public void changePlayerNickname(String oldNickname, String newNickname) {
        if (this.isActive()) {
            for (int i = 0; i < this.players.length; ++i) {
                if (!this.players[i].getNickname().equals(oldNickname)) continue;
                this.players[i].setNickname(newNickname);
            }
        } else {
            for (int i = 0; i < this.waitingUsers.size(); ++i) {
                if (!this.waitingUsers.get(i).getNickname().equals(oldNickname)) continue;
                this.waitingUsers.get(i).setNickname(newNickname);
            }
        }
    }

    public LobbyInfo toLobbyInfo() {
        User[] users = this.players;
        if (!this.isActive() && !this.isFinished()) {
            users = (User[])this.waitingUsers.toArray(User[]::new);
        }
        if (this.isFinished()) {
            User emptyUser = new User("empty");
            users = (User[])Stream.generate(() -> emptyUser).limit(4L).toArray(User[]::new);
        }
        return new LobbyInfo(this.getLobbyID(), users, this.isActive(), this.isFinished());
    }

    public void removeWaitingUser(User user) {
        this.waitingUsers.remove(user);
    }

    public void setPhase(GameState.Phase phase) {
        this.phase = phase;
    }

    class MoveResult {
        public Integer resultingPosition;
        public Integer positionBeforeMove;
        public Integer figureIndex;
        public Integer moves;
        public Integer playerIndex;

        public MoveResult(Game this$0, Integer resPos, Integer posBeforeMove, Integer figIndex, Integer moves, Integer playerIndex) {
            this.resultingPosition = resPos;
            this.positionBeforeMove = posBeforeMove;
            this.figureIndex = figIndex;
            this.moves = moves;
            this.playerIndex = playerIndex;
        }
    }
}

