/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gameLogic;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Card;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.Arrays;
import java.util.Objects;
import java.util.Vector;
import java.util.stream.Collectors;

public class Hand {
    User user;
    public Vector<Card> cards;

    public Hand(User user, Card[] cards) {
        this.user = user;
        this.cards = Arrays.stream(cards).collect(Collectors.toCollection(Vector::new));
    }

    public Card getCardAt(int i) {
        return this.cards.get(i);
    }

    public Vector<Card> getCards() {
        return this.cards;
    }

    public boolean hasJoker() {
        return this.cards.stream().anyMatch(Card::isJokerCard);
    }

    public void swapJokerWithCard(Card otherCard) {
        if (!this.hasJoker()) {
            return;
        }
        for (int i = 0; i < this.cards.size(); ++i) {
            if (!this.cards.get(i).isJokerCard()) continue;
            this.cards.set(i, otherCard);
            return;
        }
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Hand hand = (Hand)o;
        return Objects.equals(this.user, hand.user) && this.cards.equals(hand.cards);
    }
}

