/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gameLogic;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChangeNickname;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class NicknameHelper {
    public static ChangeNickname changeNickname(ChangeNickname changeNickname, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<String, Integer> nicknameToLobbyID, ConcurrentHashMap<Integer, Game> games) throws RuntimeException {
        Integer deletedPortValue = loggedInUsers.remove(changeNickname.getOldNickname());
        String resultNewNickname = changeNickname.getNewNickname();
        if (deletedPortValue == null) {
            throw new RuntimeException("Old nickname: " + changeNickname.getOldNickname() + " does not exist");
        }
        resultNewNickname = NicknameHelper.makeNameUnique(changeNickname.getNewNickname(), loggedInUsers);
        loggedInUsers.put(resultNewNickname, deletedPortValue);
        Integer deletedLobbyID = nicknameToLobbyID.remove(changeNickname.getOldNickname());
        nicknameToLobbyID.put(resultNewNickname, deletedLobbyID);
        games.get(deletedLobbyID).changePlayerNickname(changeNickname.getOldNickname(), resultNewNickname);
        return new ChangeNickname(changeNickname.getOldNickname(), resultNewNickname);
    }

    public static String makeNameUnique(String name, ConcurrentHashMap<String, Integer> lookupTable) {
        int newAppendix;
        String newName;
        if (!lookupTable.containsKey(name)) {
            return name;
        }
        Random rando = new Random();
        while (lookupTable.containsKey(newName = name + (newAppendix = rando.nextInt(9999) + 1))) {
        }
        return newName;
    }

    public static String getCurrentNicknameFromPort(Integer port, ConcurrentHashMap<String, Integer> loggedInUsers) {
        return loggedInUsers.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).equals(port)).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static BlockingQueue<String> getQueueByNickname(String nickname, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues, ConcurrentHashMap<String, Integer> loggedInUsers) {
        return Optional.ofNullable(loggedInUsers.get(nickname)).map(userQueues::get).orElse(null);
    }

    public static Integer getLobbyIdFromNickname(String nickname, ConcurrentHashMap<String, Integer> usersToLobbyId) {
        return usersToLobbyId.get(nickname);
    }
}

