/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx;

import ch.unibas.dmi.dbis.cs108.example.client.GameClientNonBlocking;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.LoginModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.ResourceManager;
import ch.unibas.dmi.dbis.cs108.example.protocol.Address;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import javafx.application.Application;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class App
extends Application {
    @Override
    public void start(Stage stage) throws URISyntaxException, IOException {
        stage.getIcons().add(new Image(this.getClass().getResourceAsStream("/images/icons/logo.png")));
        List<String> commandLineArguments = this.getParameters().getRaw();
        if (commandLineArguments.isEmpty()) {
            throw new IllegalArgumentException("We expect <ip-address>:<port> as a parameter. ex. \"127.0.0.1:8080\"");
        }
        if (commandLineArguments.size() == 2) {
            LoginModel model = Model.getInstance().getLoginModel();
            model.setUsername(commandLineArguments.getLast());
        }
        Address address = Address.parseAddress(commandLineArguments.getFirst());
        GameClientNonBlocking.getInstance(address);
        Model.getInstance().getViewFactory().showLoginScreen();
        ResourceManager resourceManager = ResourceManager.getInstance();
        resourceManager.preLoader();
    }
}

