/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Controllers;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.SystemInfo;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.LoginModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.ResourceManager;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;

public class LoginController
implements Initializable {
    public Button join_btn;
    public TextField nicknameField;
    public TextField lobbyField;
    public ListView LobbyList;
    public TextField joinLobbyIdField;
    public Button createLobbyButton;
    public Button randomLobbyButton;
    public ListView leaderBoardList;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        LoginModel loginModel = Model.getInstance().getLoginModel();
        ResourceManager resourceManager = Model.getInstance().getRessourceManager();
        if (loginModel.getNickname() != null) {
            this.nicknameField.setText(loginModel.getNickname());
        } else {
            this.nicknameField.setText(SystemInfo.getUserName());
        }
        this.nicknameField.textProperty().addListener((observable, oldValue, newValue) -> {
            String filtered = newValue.replaceAll("[;,:]", "");
            if (!filtered.equals(newValue)) {
                this.nicknameField.setText(filtered);
                resourceManager.playAudio("error_005.wav");
            }
        });
        this.joinLobbyIdField.textProperty().addListener((observable, oldValue, newValue) -> {
            String filtered = newValue.replaceAll("[^0-9]", "");
            if (!filtered.equals(newValue)) {
                this.joinLobbyIdField.setText(filtered);
                resourceManager.playAudio("error_005.wav");
            }
        });
        boolean isNicknameEmpty = this.nicknameField.getText().trim().isEmpty();
        boolean isLobbyIdEmpty = this.joinLobbyIdField.getText().trim().isEmpty();
        this.join_btn.setDisable(isNicknameEmpty || isLobbyIdEmpty);
        this.createLobbyButton.setDisable(isNicknameEmpty);
        this.randomLobbyButton.setDisable(isNicknameEmpty);
        this.nicknameField.textProperty().addListener((observable, oldValue, newValue) -> {
            boolean isNickEmpty = newValue.trim().isEmpty();
            boolean isLobbyEmpty = this.joinLobbyIdField.getText().trim().isEmpty();
            this.join_btn.setDisable(isNickEmpty || isLobbyEmpty);
            this.createLobbyButton.setDisable(isNickEmpty);
            this.randomLobbyButton.setDisable(isNickEmpty);
        });
        this.joinLobbyIdField.textProperty().addListener((observable, oldValue, newValue) -> {
            boolean isNickEmpty = this.nicknameField.getText().trim().isEmpty();
            boolean isLobbyEmpty = newValue.trim().isEmpty();
            this.join_btn.setDisable(isNickEmpty || isLobbyEmpty);
        });
        this.randomLobbyButton.setOnAction(event -> {
            loginModel.setUsername(this.nicknameField.getText());
            loginModel.joinRandomLobbies(this.nicknameField.getText());
            resourceManager.playAudio("buttonPressLobby.wav");
        });
        this.createLobbyButton.setOnAction(event -> {
            loginModel.setUsername(this.nicknameField.getText());
            loginModel.createRandomLobby(this.nicknameField.getText());
            resourceManager.playAudio("buttonPressLobby.wav");
        });
        this.join_btn.setOnAction(event -> {
            loginModel.setUsername(this.nicknameField.getText());
            loginModel.joinExistingLobby(this.nicknameField.getText(), this.joinLobbyIdField.getText());
            resourceManager.playAudio("buttonPressLobby.wav");
        });
        this.LobbyList.setItems(loginModel.getLobbyList());
        this.leaderBoardList.setItems(loginModel.getLeaderBoard());
    }
}

