/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Controllers;

import ch.unibas.dmi.dbis.cs108.example.client.GameClientNonBlocking;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.GameModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.LoginModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.ResourceManager;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.WinModel;
import ch.unibas.dmi.dbis.cs108.example.protocol.LoginMessage;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;

public class WinController
implements Initializable {
    public Pane confettiContainer;
    public Text victoryText;
    public Button returnToLobbyButton;
    public Text playerNames;
    public StackPane winScreenRoot;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        LoginModel loginModel = Model.getInstance().getLoginModel();
        GameModel gameModel = Model.getInstance().getGameModel();
        WinModel winModel = Model.getInstance().getWinModel();
        this.victoryText.setText("The game has ended");
        String winners = winModel.getWinningTeamNames();
        String losers = winModel.getLosingTeamNames();
        this.playerNames.setText("Winners: " + winners + "\nLosers: " + losers);
        this.returnToLobbyButton.setOnAction(event -> {
            ResourceManager.getInstance().playAudio("leaveGame.wav");
            Protocol protocol = new Protocol();
            String user = loginModel.getNickname();
            LoginMessage logOutMessage = new LoginMessage(user, 1111);
            String logoutMessage = protocol.encodeLogout(logOutMessage);
            GameClientNonBlocking client = GameClientNonBlocking.getInstance();
            client.sendToServer(logoutMessage);
            gameModel.updateGameReadyToFalse();
            Model.getInstance().getViewFactory().showLoginScreen();
        });
    }
}

