/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models;

import ch.unibas.dmi.dbis.cs108.example.GuiChatContent;
import ch.unibas.dmi.dbis.cs108.example.client.GameClientNonBlocking;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Card;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Hand;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.LoginModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.PopupManager;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.ResourceManager;
import ch.unibas.dmi.dbis.cs108.example.protocol.AceMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigureMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigurePositions;
import ch.unibas.dmi.dbis.cs108.example.protocol.FourMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameState;
import ch.unibas.dmi.dbis.cs108.example.protocol.JackMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.JokerMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.KingMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.LobbyInfo;
import ch.unibas.dmi.dbis.cs108.example.protocol.Move;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import ch.unibas.dmi.dbis.cs108.example.protocol.SevenMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.SimpleMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.SkipMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.TradeMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.function.Function;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Window;
import javafx.util.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameModel {
    private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");
    private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
    private final ObservableList<String> messages = FXCollections.observableArrayList();
    private static GameModel instance;
    private final List<Point2D> circlePositions = new ArrayList<Point2D>();
    private final List<Circle> figures = new ArrayList<Circle>();
    private final List<ImageView> cardViews = new ArrayList<ImageView>();
    public final ObjectProperty<GameState> currentGameStateProperty = new SimpleObjectProperty<Object>(null);
    public final ObjectProperty<GameState.Phase> currentPhaseProperty = new SimpleObjectProperty<Object>(null);
    private final BooleanProperty gameReady = new SimpleBooleanProperty(false);
    private boolean tradePhase = true;
    private Popup infoPopup;
    private PauseTransition hideDelay = new PauseTransition(Duration.millis(200.0));
    private Node windowDimension;
    private Popup optionsPopup;

    public static GameModel getInstance() {
        if (instance == null) {
            instance = new GameModel();
        }
        return instance;
    }

    private GameModel() {
        this.hideDelay.setOnFinished(event -> {
            if (this.infoPopup != null && this.infoPopup.isShowing()) {
                this.hideInfoPopup();
            }
        });
    }

    private Node createPopupContent() {
        VBox contentBox = new VBox(15.0);
        contentBox.setPadding(new Insets(20.0));
        contentBox.setStyle("    -fx-background-color: white;\n    -fx-border-radius: 10;\n    -fx-background-radius: 10;\n    -fx-effect: dropshadow(two-pass-box, rgba(0,0,0,0.1), 8, 0, 0, 4);\n");
        contentBox.setMaxWidth(480.0);
        Function<String, Label> sectionTitle = titleText -> {
            Label label = new Label((String)titleText);
            label.setFont(Font.font("Arial", FontWeight.BOLD, 16.0));
            label.setTextFill(Color.web("#333"));
            return label;
        };
        Function<String, Label> bodyText = text -> {
            Label label = new Label((String)text);
            label.setWrapText(true);
            label.setMaxWidth(440.0);
            label.setStyle("-fx-font-size: 13px; -fx-text-fill: #555;");
            return label;
        };
        contentBox.getChildren().addAll((Node[])new Node[]{sectionTitle.apply("\u00dcberblick"), bodyText.apply("DOG ist ein team-basiertes Brettspiel, das \u00e4hnlich wie \"Eile mit Weile\" funktioniert, jedoch durch den Einsatz von Karten taktischer gestaltet wird. Ziel ist es, alle 8 Spielfiguren eines Teams als erstes ins Ziel zu bringen."), sectionTitle.apply("Spielziel"), bodyText.apply("Die gegen\u00fcbersitzenden Spieler/innen bilden ein Team und arbeiten zusammen. Jedes Team muss seine 8 Spielfiguren durch den geschickten Einsatz von Karten im Gegenuhrzeigersinn vom Start- in den Zielraum bringen. Eine Einzelperson kann nicht gewinnen \u2013 nur das Team, das alle 8 Figuren ins Ziel bringt."), sectionTitle.apply("Spielablauf"), bodyText.apply("1. Zu Beginn erh\u00e4lt jede/r Spieler/in 6 Karten.\n2. Vor jeder Runde tauschen die Partner verdeckt je eine Karte.\n3. Spieler/innen legen der Reihe nach eine Karte offen ab und bewegen ihre Spielfigur entsprechend des Kartenwertes.\n4. Kann eine Person nicht ziehen, legt sie alle ihre Karten ab und setzt die restliche Runde aus.\n5. Eine Runde endet, wenn alle Karten gespielt wurden.\n6. In den n\u00e4chsten Runden reduziert sich die Kartenanzahl (6, 5, 4, 3, 2), bevor der Zyklus erneut beginnt.\n7. Das Spiel endet, wenn ein Team alle 8 Figuren ins Ziel gebracht hat."), sectionTitle.apply("Startbedingungen"), bodyText.apply("- Nur mit Ass, K\u00f6nig oder Joker kann eine Figur aus dem Startraum auf das Startfeld gesetzt werden.\n- Eine Figur auf dem Startfeld ist gesch\u00fctzt und kann nicht geschlagen oder getauscht werden."), sectionTitle.apply("Besondere Regeln"), new VBox(5.0, new Label(this, "Heimschicken:"){
            {
                this.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
                this.setTextFill(Color.web("#444"));
            }
        }, bodyText.apply("- Treffen zwei Spielfiguren auf das gleiche Feld, wird die eingeholte Figur in den Startraum zur\u00fcckgeschickt.\n- Wird eine Figur von einer \"Sieben\" \u00fcberholt, muss sie zur\u00fcck in den Startraum.\n- Eine Figur auf einer fremden Startposition wird zur\u00fcckgesetzt, wenn die Person, der die Startposition geh\u00f6rt, eine neue Figur ins Spiel bringt."), new Label(this, "Zugzwang:"){
            {
                this.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
                this.setTextFill(Color.web("#444"));
            }
        }, bodyText.apply("- Jede Karte muss ausgespielt werden. Z.B. auch dann, wenn unmittelbar vor dem Ziel eine zu hohe Karte \u00fcbrig ist, wodurch man erneut eine ganze Runde auf dem Spielbrett zur\u00fccklegen muss."), new Label(this, "Zielraum:"){
            {
                this.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
                this.setTextFill(Color.web("#444"));
            }
        }, bodyText.apply("- Der Zielraum darf nur vorw\u00e4rts betreten werden.\n- Um in den Zielraum zu gelangen, muss die Startposition mindestens zwei Mal ber\u00fchrt werden.\n- R\u00fcckw\u00e4rtsfahren in den Zielraum ist nicht erlaubt.\n- Innerhalb des Zielraums darf nicht \u00fcberholt oder zur\u00fcckgezogen werden."), sectionTitle.apply("Kartenwerte im Spiel DOG"), new Label(this, "Allgemeine Regeln"){
            {
                this.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
                this.setTextFill(Color.web("#444"));
            }
        }, bodyText.apply("Jede Karte im Spiel DOG hat eine spezifische Bedeutung und erlaubt unterschiedliche Spielz\u00fcge. Die Spieler m\u00fcssen ihre Karten taktisch nutzen, um ihre Spielfiguren vorw\u00e4rts zu bewegen, gegnerische Steine zur\u00fcckzuschicken oder spezielle Aktionen durchzuf\u00fchren."), new Label(this, "Kartenwerte und ihre Effekte"){
            {
                this.setFont(Font.font("Arial", FontWeight.BOLD, 14.0));
                this.setTextFill(Color.web("#444"));
            }
        }, new Label(this, "    ASS: 1 oder 11 Punkte vorw\u00e4rts oder vom Startraum starten\n    K\u00d6NIG: 13 Punkte vorw\u00e4rts oder vom Startraum starten\n    DAME: 12 Punkte vorw\u00e4rts\n    BUBE: Figurentausch\n    ZEHN: 10 Punkte vorw\u00e4rts\n    NEUN: 9 Punkte vorw\u00e4rts\n    ACHT: 8 Punkte vorw\u00e4rts\n    SIEBEN: Aufteilbar, \u00fcberholte Figuren heim\n    SECHS: 6 Punkte vorw\u00e4rts\n    F\u00dcNF: 5 Punkte vorw\u00e4rts\n    VIER: 4 vorw\u00e4rts oder r\u00fcckw\u00e4rts\n    DREI: 3 Punkte vorw\u00e4rts\n    ZWEI: 2 Punkte vorw\u00e4rts\n    JOKER: Beliebiger Kartenwert\n"){
            {
                this.setFont(Font.font("Monospaced", 12.0));
                this.setStyle("-fx-text-fill: #444;");
                this.setWrapText(true);
                this.setMaxWidth(440.0);
            }
        })});
        ScrollPane scrollPane = new ScrollPane(contentBox);
        scrollPane.setPrefHeight(500.0);
        scrollPane.setFitToWidth(true);
        scrollPane.setStyle("-fx-background-color: transparent; -fx-border-color: transparent;");
        scrollPane.setOnMouseExited(e -> this.hideInfoPopup());
        return scrollPane;
    }

    public void showInfoPopup(Node anchorNode) {
        this.hideDelay.stop();
        this.windowDimension = anchorNode;
        if (this.infoPopup == null) {
            this.infoPopup = new Popup();
            this.infoPopup.setAutoHide(false);
            this.infoPopup.setHideOnEscape(true);
            this.infoPopup.getContent().add(this.createPopupContent());
            ((Node)this.infoPopup.getContent().get(0)).setOnMouseEntered(event -> this.hideDelay.stop());
        }
        if (!this.infoPopup.isShowing()) {
            Window window = anchorNode.getScene().getWindow();
            Bounds bounds = anchorNode.localToScreen(anchorNode.getBoundsInLocal());
            double popupX = bounds.getMinX();
            double popupY = bounds.getMaxY() + 5.0;
            if (popupY + 400.0 > Screen.getPrimary().getVisualBounds().getHeight()) {
                popupY = bounds.getMinY() - 400.0 - 5.0;
            }
            this.infoPopup.show(window, popupX, popupY);
        }
    }

    public void hideInfoPopup() {
        this.hideDelay.stop();
        if (this.infoPopup != null && this.infoPopup.isShowing()) {
            this.infoPopup.hide();
        }
    }

    public void startHidePopupTimer() {
        this.hideDelay.playFromStart();
    }

    public BooleanProperty gameReadyProperty() {
        return this.gameReady;
    }

    public void updateGameState(GameState newState) {
        this.currentGameStateProperty.set(newState);
        this.gameReady.setValue(true);
        this.currentPhaseProperty.setValue(newState.getPhase());
        if (newState.getPhase() == GameState.Phase.PLAY) {
            this.tradePhase = false;
        }
        if (newState.getPhase() == GameState.Phase.TRADE) {
            this.tradePhase = true;
        }
    }

    public void updateGameReadyToFalse() {
        this.gameReady.setValue(false);
    }

    private void handleAce(ImageView card, Card chosenCard, int playerFigureId) {
        PopupManager popupManager = new PopupManager();
        popupManager.showChoicePopup(card, "Move 1", "Move 11", () -> this.sendMoveToServer(new AceMove(chosenCard, playerFigureId, 1)), () -> this.sendMoveToServer(new AceMove(chosenCard, playerFigureId, 11)));
    }

    private void handleFour(ImageView card, Card chosenCard, int playerFigureId) {
        PopupManager popupManager = new PopupManager();
        popupManager.showChoicePopup(card, "Forward (+4)", "Backward (-4)", () -> this.sendMoveToServer(new FourMove(chosenCard, playerFigureId, FourMove.Direction.FORWARD)), () -> this.sendMoveToServer(new FourMove(chosenCard, playerFigureId, FourMove.Direction.BACKWARD)));
    }

    private void handleJack(Card chosenCard, int playerFigureId, Circle enemyFigure) {
        Point2D pointEnemy = new Point2D(enemyFigure.getTranslateX(), enemyFigure.getTranslateY());
        int enemyFigureId = this.circlePositions.indexOf(pointEnemy);
        this.sendMoveToServer(new JackMove(chosenCard, playerFigureId, enemyFigureId));
    }

    private void handleJoker(ImageView card) {
        List<String> cardKeysToShow = List.of("HEART:ACE", "DIAMOND:TWO", "CLUB:THREE", "SPADE:FOUR", "HEART:FIVE", "DIAMOND:SIX", "CLUB:SEVEN", "SPADE:EIGHT", "HEART:NINE", "DIAMOND:TEN", "CLUB:JACK", "SPADE:QUEEN", "HEART:KING");
        PopupManager popupManager = new PopupManager();
        popupManager.showChoicePopup(card, cardKeysToShow, selectedKeys -> this.sendMoveToServer(new JokerMove(this.getCardFromString((String)selectedKeys))));
    }

    public void handleSeven(ImageView card, List<Circle> card7SelectionFigures, Runnable afterCompletionCallback) {
        PopupManager popupManager = new PopupManager();
        popupManager.showSevenPopup(card, card7SelectionFigures, afterCompletionCallback, vectorDistribution -> {
            System.out.println("VECTOR" + String.valueOf(vectorDistribution));
            this.sendMoveToServer(new SevenMove((Vector<FigureMove>)vectorDistribution));
        });
    }

    public void handleTrade(ImageView card) {
        Card chosenCard = this.getCard(card);
        this.sendMoveToServer(new TradeMove(chosenCard));
    }

    public void cardSelector(ImageView card, Circle playerFigure, Circle enemyFigure) {
        Point2D point = new Point2D(playerFigure.getTranslateX(), playerFigure.getTranslateY());
        int playerFigureId = this.circlePositions.indexOf(point);
        Card chosenCard = this.getCard(card);
        switch (chosenCard.getValue()) {
            case ACE: {
                this.handleAce(card, chosenCard, playerFigureId);
                break;
            }
            case KING: {
                this.sendMoveToServer(new KingMove(chosenCard, playerFigureId, 13));
                break;
            }
            case FOUR: {
                this.handleFour(card, chosenCard, playerFigureId);
                break;
            }
            case JACK: {
                this.handleJack(chosenCard, playerFigureId, enemyFigure);
                break;
            }
            case JOKERVALUE: {
                this.handleJoker(card);
                break;
            }
            case NULLVALUE: {
                this.sendMoveToServer(new SkipMove());
                break;
            }
            default: {
                this.sendMoveToServer(new SimpleMove(chosenCard, playerFigureId));
            }
        }
    }

    public int getFigureIntPosition(Circle playerFigure) {
        Point2D point = new Point2D(playerFigure.getTranslateX(), playerFigure.getTranslateY());
        int playerFigureId = this.circlePositions.indexOf(point);
        return playerFigureId;
    }

    public void sendMoveToServer(Move move) {
        GameClientNonBlocking client = GameClientNonBlocking.getInstance();
        Protocol p = new Protocol();
        client.sendToServer(p.encodeMove(move));
    }

    public Card getCard(ImageView card) {
        String path = card.getImage().getUrl();
        String[] cardValues = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf(".")).split("_");
        Card.Sign sign = Card.Sign.valueOf(cardValues[0].toUpperCase());
        Card.Value value = Card.Value.valueOf(cardValues[1].toUpperCase());
        return new Card(sign, value);
    }

    public Card getCardFromString(String imageName) {
        String[] cardValues = imageName.split(":");
        Card.Sign sign = Card.Sign.valueOf(cardValues[0].toUpperCase());
        Card.Value value = Card.Value.valueOf(cardValues[1].toUpperCase());
        return new Card(sign, value);
    }

    public Card.Value getCardValue(ImageView card) {
        String path = card.getImage().getUrl();
        String[] cardValues = path.substring(path.lastIndexOf("/") + 1, path.lastIndexOf(".")).split("_");
        Card.Value value = Card.Value.valueOf(cardValues[1].toUpperCase());
        Card.Sign sign = Card.Sign.valueOf(cardValues[0].toUpperCase());
        Card selectedCard = new Card(sign, value);
        return selectedCard.getValue();
    }

    public void foldCardsSelection() {
        GameClientNonBlocking client = GameClientNonBlocking.getInstance();
        Protocol protocol = new Protocol();
        client.sendToServer(protocol.encodeMove(new SkipMove()));
    }

    public void initializeCirclePositions(List<Circle> circles) {
        this.circlePositions.clear();
        if (circles != null) {
            for (Circle circle : circles) {
                this.circlePositions.add(new Point2D(circle.getTranslateX(), circle.getTranslateY()));
            }
        }
    }

    public Point2D getCirclePosition(int index) {
        if (index >= 0 && index < this.circlePositions.size()) {
            return this.circlePositions.get(index);
        }
        return null;
    }

    public boolean getPhase() {
        return this.tradePhase;
    }

    public void sendChatContent(String content, boolean defaultToAll) {
        Protocol protocol = new Protocol();
        LoginModel loginModel = Model.getInstance().getLoginModel();
        GameClientNonBlocking client = GameClientNonBlocking.getInstance();
        Optional<Integer> lobbyId = Optional.empty();
        if (!defaultToAll) {
            lobbyId = loginModel.getLobbyIdToUser(loginModel.getNickname());
        }
        GuiChatContent chatContent = protocol.parseGuiChat(content, loginModel.getNickname(), lobbyId);
        String encodedChat = protocol.encodeGuiChatContent(chatContent);
        client.sendToServer(encodedChat);
    }

    public ObservableList<String> getMessages() {
        return this.messages;
    }

    public void clearChatMessages() {
        Platform.runLater(this.messages::clear);
    }

    public void addMessages(String message) {
        LoginModel loginModel = Model.getInstance().getLoginModel();
        Protocol protocol = new Protocol();
        GuiChatContent chatContent = protocol.GuiParseChatDisplay(message);
        String messageDisplay = chatContent.getFormattedMessage(loginModel.getNickname());
        Platform.runLater(() -> this.messages.add(messageDisplay));
    }

    public void AdjustStartPositions(List<Circle> circles, List<ImageView> cardViewsL) {
        this.figures.clear();
        this.figures.addAll(circles);
        this.cardViews.clear();
        this.cardViews.addAll(cardViewsL);
        for (int i = 0; i < circles.size(); ++i) {
            int index = 16 + i;
            if (index < this.circlePositions.size()) {
                Point2D position = this.circlePositions.get(index);
                circles.get(i).setTranslateX(position.getX());
                circles.get(i).setTranslateY(position.getY());
                continue;
            }
            errorLogger.error("Warning: Index {} is out of bounds for circlePositions", (Object)index);
        }
    }

    public void updateGameDisplay(GameState gameState, Label player1Name, Label player2Name, Label player3Name, Label player4Name, Label turnLabel, String nickname, List<ImageView> visualCards) {
        LoginModel loginModel = Model.getInstance().getLoginModel();
        User turnUser = gameState.getTurn();
        Object turnText = "Current turn: -";
        if (turnUser != null) {
            turnText = "Current turn: " + turnUser.getNickname();
            if (turnUser.getNickname().equals(loginModel.getNickname())) {
                turnText = "Current turn: You";
            }
        }
        turnLabel.setText((String)turnText);
        User[] players = gameState.getPlayers();
        Label[] nameLabels = new Label[]{player1Name, player2Name, player3Name, player4Name};
        for (int i = 0; i < nameLabels.length; ++i) {
            if (players[i].getNickname().equals(loginModel.getNickname())) {
                nameLabels[i].setText(players[i].getNickname() + " (You)");
                continue;
            }
            nameLabels[i].setText(players[i].getNickname());
        }
        FigurePositions[] allPositions = gameState.getPositions();
        for (int playerIndex = 0; playerIndex < allPositions.length; ++playerIndex) {
            FigurePositions playerPos = allPositions[playerIndex];
            for (int figureIndex = 0; figureIndex < playerPos.pos.length; ++figureIndex) {
                if (playerPos.pos[figureIndex] == -1 || figureIndex >= 96) {
                    errorLogger.error("Warning: Index {} is out of bounds for pos", (Object)figureIndex);
                    errorLogger.error(((GameState)this.currentGameStateProperty.get()).toString());
                    errorLogger.error(this.figures.toString());
                }
                Integer targetFieldIndex = playerPos.getPosAt(figureIndex);
                int globalFigureIndex = playerIndex * 4 + figureIndex;
                Circle figureCircle = this.figures.get(globalFigureIndex);
                Point2D targetCoords = this.circlePositions.get(targetFieldIndex);
                TranslateTransition tt = new TranslateTransition(Duration.millis(300.0), figureCircle);
                tt.setToX(targetCoords.getX());
                tt.setToY(targetCoords.getY());
                tt.play();
            }
        }
        Hand[] hands = gameState.getHands();
        Hand localPlayerHand = null;
        for (int i = 0; i < players.length; ++i) {
            if (!players[i].getNickname().equals(loginModel.getNickname())) continue;
            localPlayerHand = hands[i];
        }
        ResourceManager resourceManager = ResourceManager.getInstance();
        for (int i = 0; i < this.cardViews.size(); ++i) {
            Vector<Card> cards = localPlayerHand.cards;
            ImageView cardView = this.cardViews.get(i);
            if (i < cards.size()) {
                String imageKey = cards.get(i).toString();
                Image cardImage = resourceManager.getImage(imageKey);
                if (cardImage != null) {
                    cardView.setImage(cardImage);
                    cardView.setVisible(true);
                    continue;
                }
                cardView.setVisible(false);
                continue;
            }
            cardView.setVisible(false);
        }
        for (int playerIndex = 0; playerIndex < 4; ++playerIndex) {
            int cardCount = hands[playerIndex].cards.size();
            for (int cardIndex = 0; cardIndex < 6; ++cardIndex) {
                int visualIndex = playerIndex * 6 + cardIndex;
                ImageView cardView = visualCards.get(visualIndex);
                if (cardIndex < cardCount) {
                    cardView.setVisible(true);
                    continue;
                }
                cardView.setVisible(false);
            }
        }
    }

    public void updatePlayerLabels(Label player1Name, Label player2Name, Label player3Name, Label player4Name, ObservableList<LobbyInfo> currentLobbyList, Label lobbyIdLabel) {
        List<Label> playerLabels = Arrays.asList(player1Name, player2Name, player3Name, player4Name);
        int index = 0;
        if (currentLobbyList != null && !currentLobbyList.isEmpty()) {
            LobbyInfo lobbyInfo = (LobbyInfo)currentLobbyList.getFirst();
            for (User player : lobbyInfo.players) {
                lobbyIdLabel.setText("Lobby ID: " + lobbyInfo.lobbyID);
                if (player == null) {
                    playerLabels.get(index).setText("Waiting...");
                } else if (playerLabels.get(index).getText().contains("(You)")) {
                    Parent parent = playerLabels.get(index).getParent();
                    if (parent instanceof HBox) {
                        HBox playerBox = (HBox)parent;
                        playerBox.setStyle("-fx-background-color: #8e9baf;");
                    }
                    playerLabels.get(index).setText(player.getNickname() + "(You)");
                } else {
                    playerLabels.get(index).setText(player.getNickname());
                }
                ++index;
            }
        }
    }

    public List<Circle> GiveUserCorrespondingFigures(List<Circle> figures, ObservableList<LobbyInfo> currentLobbyList, String nickname) {
        if (currentLobbyList != null && !currentLobbyList.isEmpty()) {
            LobbyInfo lobbyInfo = (LobbyInfo)currentLobbyList.getFirst();
            int index = 0;
            for (User player : lobbyInfo.players) {
                if (player.getNickname().equals(nickname)) {
                    int fromIndex = index * 4;
                    int toIndex = fromIndex + 4;
                    if (fromIndex >= 0 && toIndex <= figures.size()) {
                        return figures.subList(fromIndex, toIndex);
                    }
                }
                ++index;
            }
        }
        System.out.println(currentLobbyList.isEmpty());
        generalLogger.debug("CurrentLobbyList is empty: {} ", (Object)currentLobbyList.isEmpty());
        return Collections.emptyList();
    }

    public List<Circle> GiveOtherUserFigures(List<Circle> figures, ObservableList<LobbyInfo> currentLobbyList, String nickname) {
        if (currentLobbyList != null && !currentLobbyList.isEmpty()) {
            LobbyInfo lobbyInfo = (LobbyInfo)currentLobbyList.getFirst();
            int index = 0;
            for (User player : lobbyInfo.players) {
                if (player.getNickname().equals(nickname)) {
                    int fromIndex = index * 4;
                    int toIndex = fromIndex + 4;
                    if (fromIndex >= 0 && toIndex <= figures.size()) {
                        ArrayList<Circle> otherFigures = new ArrayList<Circle>(figures);
                        otherFigures.subList(fromIndex, toIndex).clear();
                        return otherFigures;
                    }
                }
                ++index;
            }
        }
        System.out.println(currentLobbyList.isEmpty());
        generalLogger.debug("CurrentLobbyList is empty: {} ", (Object)currentLobbyList.isEmpty());
        return Collections.emptyList();
    }

    public void showTradePhaseBanner(Node anchorNode, String message) {
        Platform.runLater(() -> {
            Pane parent = (Pane)anchorNode.getParent();
            Label banner = new Label(message);
            banner.setStyle("-fx-background-color: rgba(0,0,0,0.8); -fx-text-fill: white; -fx-padding: 10px 20px; -fx-font-size: 16px; -fx-background-radius: 10;");
            banner.setOpacity(0.0);
            banner.setTranslateY(-50.0);
            parent.getChildren().add(banner);
            banner.applyCss();
            banner.layout();
            double centerX = (parent.getWidth() - banner.prefWidth(-1.0)) / 2.0;
            banner.setLayoutX(centerX);
            banner.setLayoutY(0.0);
            TranslateTransition slideIn = new TranslateTransition(Duration.millis(300.0), banner);
            slideIn.setFromY(-50.0);
            slideIn.setToY(20.0);
            slideIn.setInterpolator(Interpolator.EASE_OUT);
            FadeTransition fadeIn = new FadeTransition(Duration.millis(300.0), banner);
            fadeIn.setFromValue(0.0);
            fadeIn.setToValue(1.0);
            TranslateTransition slideOut = new TranslateTransition(Duration.millis(300.0), banner);
            slideOut.setFromY(20.0);
            slideOut.setToY(-50.0);
            slideOut.setInterpolator(Interpolator.EASE_IN);
            FadeTransition fadeOut = new FadeTransition(Duration.millis(300.0), banner);
            fadeOut.setFromValue(1.0);
            fadeOut.setToValue(0.0);
            PauseTransition pause = new PauseTransition(Duration.seconds(4.0));
            slideOut.setOnFinished(e -> parent.getChildren().remove(banner));
            SequentialTransition sequence = new SequentialTransition(new ParallelTransition(slideIn, fadeIn), pause, new ParallelTransition(slideOut, fadeOut));
            sequence.play();
        });
    }
}

