/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models;

import ch.unibas.dmi.dbis.cs108.example.client.GameClientNonBlocking;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.protocol.LobbyInfo;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class LoginModel {
    private final StringProperty currentNickname = new SimpleStringProperty();
    private ObservableList<String> lobbyList = FXCollections.observableArrayList();
    private List<LobbyInfo> lobbies = new ArrayList<LobbyInfo>();
    public final ObservableList<LobbyInfo> currentLobbyList = FXCollections.observableArrayList();
    private Integer currentLobbyID = null;
    private static LoginModel instance;
    private final ObservableList<String> leaderboard = FXCollections.observableArrayList();

    private LoginModel() {
    }

    public static LoginModel getInstance() {
        if (instance == null) {
            instance = new LoginModel();
        }
        return instance;
    }

    public String getNickname() {
        return (String)this.currentNickname.get();
    }

    public Optional<Integer> getLobbyIdToUser(String nickname) {
        return this.lobbies.stream().filter(lobby -> lobby.doesUserExist(nickname)).map(lobbyInfo -> lobbyInfo.lobbyID).findFirst();
    }

    public void addLeaderBoard(String message) {
        Platform.runLater(() -> {
            this.leaderboard.clear();
            if (message == null || message.trim().isEmpty()) {
                return;
            }
            String[] entries = message.split(";");
            for (int i = 0; i < entries.length; ++i) {
                String[] parts = entries[i].split(",");
                if (parts.length != 2) continue;
                String name = parts[0].trim();
                String score = parts[1].trim();
                this.leaderboard.add(String.format("%d. %s \u2013 %s", i + 1, name, score));
            }
        });
    }

    public void addLobbiesToList(LobbyInfo[] lobbyInfo) {
        if (lobbyInfo == null || lobbyInfo.length == 0) {
            return;
        }
        this.clearLobbyList();
        this.lobbies.clear();
        this.lobbies = new ArrayList<LobbyInfo>(Arrays.asList(lobbyInfo));
        Optional<Integer> lobbyId = this.getLobbyIdToUser((String)this.currentNickname.get());
        if (lobbyId.isPresent()) {
            this.currentLobbyID = lobbyId.get();
        }
        if (this.currentLobbyID != null) {
            this.currentLobbyList.clear();
            for (LobbyInfo lobby : this.lobbies) {
                if (!this.currentLobbyID.equals(lobby.lobbyID)) continue;
                this.currentLobbyList.add(lobby);
            }
        }
        Platform.runLater(() -> {
            this.lobbyList.clear();
            for (LobbyInfo lobby : lobbyInfo) {
                String displayText;
                int playerCount = 0;
                StringBuilder playerList = new StringBuilder();
                for (User player : lobby.players) {
                    if (player == null) continue;
                    ++playerCount;
                    if (!playerList.isEmpty()) {
                        playerList.append(", ");
                    }
                    playerList.append(player.getNickname());
                }
                if (lobby.isFinished) {
                    statusText = "Finished";
                    displayText = String.format("Lobby %d | %s", lobby.lobbyID, statusText);
                } else if (lobby.isActive) {
                    statusText = "Playing";
                    displayText = String.format("Lobby %d | %s | %d/4 | %s", lobby.lobbyID, statusText, playerCount, playerList.toString());
                } else {
                    statusText = "Waiting";
                    displayText = String.format("Lobby %d | %s | %d/4 | %s", lobby.lobbyID, statusText, playerCount, playerList.toString());
                }
                this.lobbyList.add(displayText);
            }
        });
    }

    public boolean lobbyExists(int lobbyId) {
        for (LobbyInfo lobby : this.lobbies) {
            if (lobby.lobbyID != lobbyId) continue;
            return true;
        }
        return false;
    }

    public boolean playerCountLowerThan4(int lobbyId) {
        int count = 0;
        for (LobbyInfo lobby : this.lobbies) {
            if (lobby.lobbyID != lobbyId) continue;
            for (User player : lobby.players) {
                if (player == null) continue;
                ++count;
            }
        }
        return count < 4;
    }

    public boolean isFinished(int lobbyId) {
        for (LobbyInfo lobby : this.lobbies) {
            if (lobby.lobbyID != lobbyId || !lobby.isFinished) continue;
            return true;
        }
        return false;
    }

    public boolean isActive(int lobbyId) {
        for (LobbyInfo lobby : this.lobbies) {
            if (lobby.lobbyID != lobbyId || !lobby.isActive) continue;
            return true;
        }
        return false;
    }

    public boolean joinSpecificLobbyChecker(int lobbyId) {
        boolean lobbyExists = this.lobbyExists(lobbyId);
        if (!lobbyExists) {
            return false;
        }
        boolean playerCountLowerThan4 = this.playerCountLowerThan4(lobbyId);
        if (!playerCountLowerThan4) {
            return false;
        }
        boolean isFinished = this.isFinished(lobbyId);
        if (isFinished) {
            return false;
        }
        boolean isActive = this.isActive(lobbyId);
        return !isActive;
    }

    public StringProperty nicknameProperty() {
        return this.currentNickname;
    }

    public void setUsername(String username) {
        this.currentNickname.set(username);
    }

    public void setUsernameThreadSafe(String username) {
        Platform.runLater(() -> this.currentNickname.set(username));
    }

    public void clearLobbyList() {
        Platform.runLater(this.lobbyList::clear);
    }

    public ObservableList<String> getLobbyList() {
        return this.lobbyList;
    }

    public ObservableList<String> getLeaderBoard() {
        return this.leaderboard;
    }

    public void joinRandomLobbies(String nickname) {
        String payload = "LOGIN;" + nickname + ";10000";
        GameClientNonBlocking client = GameClientNonBlocking.getInstance();
        client.sendToServer(payload);
        Model.getInstance().getViewFactory().showGameScreen();
    }

    public void createRandomLobby(String nickname) {
        Random random = new Random();
        String id = String.format("%04d", random.nextInt(10000));
        String payload = "LOGIN;" + nickname + ";" + id;
        GameClientNonBlocking client = GameClientNonBlocking.getInstance();
        client.sendToServer(payload);
        Model.getInstance().getViewFactory().showGameScreen();
    }

    public void joinExistingLobby(String nickname, String lobbyId) {
        boolean pass = this.joinSpecificLobbyChecker(Integer.parseInt(lobbyId));
        if (pass) {
            GameClientNonBlocking client = GameClientNonBlocking.getInstance();
            client.sendToServer("LOGIN;" + nickname + ";" + lobbyId);
            Model.getInstance().getViewFactory().showGameScreen();
        }
    }
}

