/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models;

import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.GameModel;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.ResourceManager;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigureMove;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Shape;
import javafx.stage.Popup;
import javafx.stage.Window;

public class PopupManager {
    private Popup optionsPopup;

    public void showChoicePopup(Node anchorNode, String button1Text, String button2Text, Runnable onButton1Action, Runnable onButton2Action) {
        HBox buttonContent = this.createButtonContent(button1Text, button2Text, onButton1Action, onButton2Action);
        this.displayPopupWithContent(anchorNode, buttonContent);
    }

    public void showSevenPopup(Node anchorNode, List<Circle> selectedFigures, Runnable afterCompletionCallback, Consumer<Vector<FigureMove>> vectorConsumer) {
        Node content = this.createSevenCardPane(selectedFigures, afterCompletionCallback, vectorConsumer);
        this.displayPopupWithContent(anchorNode, content);
    }

    private Node createSevenCardPane(List<Circle> selectedFigures, Runnable afterCompletionCallback, Consumer<Vector<FigureMove>> vectorConsumer) {
        List<Circle> deselect = selectedFigures;
        GameModel gameModel = Model.getInstance().getGameModel();
        VBox mainLayout = new VBox(15.0);
        mainLayout.setPadding(new Insets(20.0));
        mainLayout.setAlignment(Pos.CENTER);
        mainLayout.setStyle("-fx-background-color: white; -fx-border-color: #e0e0e0; -fx-background-radius: 8; -fx-border-radius: 8;");
        Label titleLabel = new Label("Distribute exactly 7 moves:");
        titleLabel.setStyle("-fx-font-size: 16px; -fx-font-weight: bold; -fx-padding: 0 0 10 0;");
        mainLayout.getChildren().add(titleLabel);
        VBox figuresPane = new VBox(10.0);
        figuresPane.setAlignment(Pos.CENTER_LEFT);
        HashMap<Integer, Integer> currentMoves = new HashMap<Integer, Integer>();
        HashMap<Integer, Label> moveLabels = new HashMap<Integer, Label>();
        HashMap<Integer, Button> plusButtonsMap = new HashMap<Integer, Button>();
        HashMap<Integer, Button> minusButtonsMap = new HashMap<Integer, Button>();
        int MAX_TOTAL_MOVES = 7;
        int[] totalMovesAllocated = new int[]{0};
        Label totalMovesLabel = new Label();
        totalMovesLabel.setStyle("-fx-font-size: 14px; -fx-padding: 10 0;");
        Button confirmButton = new Button("Confirm Moves");
        String baseButtonStyle = "-fx-background-radius: 4; -fx-padding: 8 16; -fx-font-weight: bold;";
        String confirmButtonStyle = "-fx-background-color: #3498db; -fx-text-fill: white; " + baseButtonStyle;
        String confirmHoverStyle = "-fx-background-color: #2980b9; -fx-text-fill: white; " + baseButtonStyle;
        confirmButton.setStyle(confirmButtonStyle);
        confirmButton.setOnMouseEntered(e -> confirmButton.setStyle(confirmHoverStyle));
        confirmButton.setOnMouseExited(e -> confirmButton.setStyle(confirmButtonStyle));
        String arrowBtnStyle = "-fx-background-color: #5dade2; -fx-text-fill: white; -fx-font-weight: bold; -fx-background-radius: 3; -fx-padding: 5 8;";
        String arrowBtnHoverStyle = "-fx-background-color: #4a90e2; -fx-text-fill: white; -fx-font-weight: bold; -fx-background-radius: 3; -fx-padding: 5 8;";
        for (Circle figure : selectedFigures) {
            int figId = gameModel.getFigureIntPosition(figure);
            currentMoves.put(figId, 0);
            HBox figureRow = new HBox(8.0);
            figureRow.setAlignment(Pos.CENTER_LEFT);
            figureRow.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
            Circle displayVisualCircle = new Circle(13.0);
            if (figure instanceof Shape) {
                displayVisualCircle.setFill(figure.getFill());
                displayVisualCircle.setStroke(figure.getStroke());
                displayVisualCircle.setStrokeWidth(figure.getStrokeWidth());
            } else {
                displayVisualCircle.setFill(Color.DODGERBLUE);
                displayVisualCircle.setStroke(Color.BLACK);
            }
            Button minusButton = new Button("-");
            minusButton.setStyle(arrowBtnStyle);
            minusButton.setOnMouseEntered(e -> minusButton.setStyle(arrowBtnHoverStyle));
            minusButton.setOnMouseExited(e -> minusButton.setStyle(arrowBtnStyle));
            Label movesForFigureLabel = new Label("0");
            movesForFigureLabel.setMinWidth(25.0);
            movesForFigureLabel.setAlignment(Pos.CENTER);
            movesForFigureLabel.setStyle("-fx-font-weight: bold;");
            Button plusButton = new Button("+");
            plusButton.setStyle(arrowBtnStyle);
            plusButton.setOnMouseEntered(e -> plusButton.setStyle(arrowBtnHoverStyle));
            plusButton.setOnMouseExited(e -> plusButton.setStyle(arrowBtnStyle));
            moveLabels.put(figId, movesForFigureLabel);
            plusButtonsMap.put(figId, plusButton);
            minusButtonsMap.put(figId, minusButton);
            minusButton.setOnAction(e -> {
                int currentFigMoves = (Integer)currentMoves.get(figId);
                if (currentFigMoves > 0) {
                    currentMoves.put(figId, currentFigMoves - 1);
                    totalMovesAllocated[0] = totalMovesAllocated[0] - 1;
                    this.updateSevenCardUIState(currentMoves, moveLabels, totalMovesLabel, confirmButton, plusButtonsMap, minusButtonsMap, totalMovesAllocated[0], 7, selectedFigures);
                }
            });
            plusButton.setOnAction(e -> {
                if (totalMovesAllocated[0] < 7) {
                    currentMoves.put(figId, (Integer)currentMoves.get(figId) + 1);
                    totalMovesAllocated[0] = totalMovesAllocated[0] + 1;
                    this.updateSevenCardUIState(currentMoves, moveLabels, totalMovesLabel, confirmButton, plusButtonsMap, minusButtonsMap, totalMovesAllocated[0], 7, selectedFigures);
                }
            });
            figureRow.getChildren().addAll((Node[])new Node[]{displayVisualCircle, minusButton, movesForFigureLabel, plusButton});
            figuresPane.getChildren().add(figureRow);
        }
        mainLayout.getChildren().add(figuresPane);
        mainLayout.getChildren().add(totalMovesLabel);
        mainLayout.getChildren().add(confirmButton);
        this.updateSevenCardUIState(currentMoves, moveLabels, totalMovesLabel, confirmButton, plusButtonsMap, minusButtonsMap, totalMovesAllocated[0], 7, selectedFigures);
        confirmButton.setOnAction(event -> {
            for (Circle figure : deselect) {
                figure.setStroke(null);
                figure.setStrokeWidth(0.0);
            }
            deselect.clear();
            Platform.runLater(() -> {
                if (afterCompletionCallback != null) {
                    afterCompletionCallback.run();
                }
            });
            Vector<FigureMove> figureMovesVector = new Vector<FigureMove>();
            for (Map.Entry entry : currentMoves.entrySet()) {
                if ((Integer)entry.getValue() <= 0) continue;
                figureMovesVector.add(new FigureMove((Integer)entry.getKey(), (Integer)entry.getValue()));
            }
            try {
                vectorConsumer.accept(figureMovesVector);
            }
            finally {
                if (this.optionsPopup != null) {
                    this.optionsPopup.hide();
                }
            }
        });
        return mainLayout;
    }

    private void updateSevenCardUIState(Map<Integer, Integer> currentMovesMap, Map<Integer, Label> moveLabelsMap, Label totalMovesLbl, Button confirmBtn, Map<Integer, Button> plusButtons, Map<Integer, Button> minusButtons, int totalAllocated, int maxTotal, List<Circle> figures) {
        GameModel gameModel = Model.getInstance().getGameModel();
        for (Map.Entry<Integer, Integer> entry : currentMovesMap.entrySet()) {
            int figId = entry.getKey();
            int movesForThisFigure = entry.getValue();
            Label label = moveLabelsMap.get(figId);
            if (label != null) {
                label.setText(String.valueOf(movesForThisFigure));
            }
            Button plusBtn = plusButtons.get(figId);
            Button minusBtn = minusButtons.get(figId);
            if (plusBtn != null) {
                plusBtn.setDisable(totalAllocated >= maxTotal);
            }
            if (minusBtn == null) continue;
            minusBtn.setDisable(movesForThisFigure <= 0);
        }
        totalMovesLbl.setText("Total Moves: " + totalAllocated + " / " + maxTotal);
        confirmBtn.setDisable(totalAllocated != maxTotal);
    }

    public void showChoicePopup(Node anchorNode, List<String> imageKeys, Consumer<String> onImageClickAction) {
        Node imageContent = this.createImageContent(imageKeys, onImageClickAction, 400.0);
        this.displayPopupWithContent(anchorNode, imageContent);
    }

    private Node createImageContent(List<String> imageKeys, Consumer<String> onImageClickAction, double maxContentWidth) {
        FlowPane imagePane = new FlowPane();
        imagePane.setPadding(new Insets(10.0));
        imagePane.setHgap(10.0);
        imagePane.setVgap(10.0);
        imagePane.setAlignment(Pos.CENTER);
        imagePane.setPrefWrapLength(maxContentWidth);
        ResourceManager resourceManager = Model.getInstance().getRessourceManager();
        if (imageKeys == null || imageKeys.isEmpty()) {
            imagePane.getChildren().add(new Label("No images to display."));
            return imagePane;
        }
        for (String key : imageKeys) {
            Image img = resourceManager.getImage(key);
            if (img != null) {
                ImageView iView = new ImageView(img);
                iView.setFitWidth(70.0);
                iView.setFitHeight(100.0);
                iView.setPreserveRatio(true);
                iView.setPickOnBounds(true);
                iView.setStyle("-fx-cursor: hand;");
                iView.setOnMouseEntered(e -> iView.setEffect(new DropShadow(10.0, Color.LIGHTBLUE)));
                iView.setOnMouseExited(e -> iView.setEffect(null));
                iView.setOnMouseClicked(event -> {
                    try {
                        onImageClickAction.accept(key);
                    }
                    finally {
                        if (this.optionsPopup != null) {
                            this.optionsPopup.hide();
                        }
                    }
                });
                imagePane.getChildren().add(iView);
                continue;
            }
            System.err.println("Warning: Could not load image for key: " + key);
        }
        return imagePane;
    }

    private HBox createButtonContent(String button1Text, String button2Text, Runnable onButton1Action, Runnable onButton2Action) {
        Button btn1 = new Button(button1Text);
        Button btn2 = new Button(button2Text);
        String buttonStyle = "-fx-background-color: #3498db; -fx-text-fill: white; -fx-background-radius: 4; -fx-padding: 8 16; -fx-font-weight: bold;";
        btn1.setStyle(buttonStyle);
        btn2.setStyle(buttonStyle);
        String hoverStyle = buttonStyle + "-fx-background-color: #2980b9;";
        btn1.setOnMouseEntered(e -> btn1.setStyle(hoverStyle));
        btn1.setOnMouseExited(e -> btn1.setStyle(buttonStyle));
        btn2.setOnMouseEntered(e -> btn2.setStyle(hoverStyle));
        btn2.setOnMouseExited(e -> btn2.setStyle(buttonStyle));
        btn1.setOnAction(event -> {
            try {
                onButton1Action.run();
            }
            finally {
                if (this.optionsPopup != null) {
                    this.optionsPopup.hide();
                }
            }
        });
        btn2.setOnAction(event -> {
            try {
                onButton2Action.run();
            }
            finally {
                if (this.optionsPopup != null) {
                    this.optionsPopup.hide();
                }
            }
        });
        HBox buttonBox = new HBox(20.0);
        buttonBox.setPadding(new Insets(10.0));
        buttonBox.setAlignment(Pos.CENTER);
        buttonBox.getChildren().addAll((Node[])new Node[]{btn1, btn2});
        return buttonBox;
    }

    private void displayPopupWithContent(Node anchorNode, Node contentNode) {
        Bounds stackPaneBounds;
        if (this.optionsPopup != null && this.optionsPopup.isShowing()) {
            this.optionsPopup.hide();
        }
        this.optionsPopup = new Popup();
        this.optionsPopup.setAutoHide(true);
        this.optionsPopup.setHideOnEscape(true);
        VBox container = new VBox();
        container.setAlignment(Pos.CENTER);
        container.getChildren().add(contentNode);
        container.setStyle("-fx-background-color: white; -fx-border-color: #e0e0e0; -fx-background-radius: 8; -fx-border-radius: 8; -fx-effect: dropshadow(three-pass-box, rgba(0,0,0,0.3), 15, 0, 0, 6);");
        container.setPadding(new Insets(10.0));
        this.optionsPopup.getContent().add(container);
        Window window = anchorNode.getScene().getWindow();
        StackPane parentStackPane = this.findParentStackPane(anchorNode);
        if (parentStackPane == null || window == null) {
            System.err.println("Warning: Could not find parent StackPane or Window for centering. Showing near anchor.");
            Bounds anchorBounds = anchorNode.localToScreen(anchorNode.getBoundsInLocal());
            if (anchorBounds != null && window != null) {
                this.optionsPopup.show(window, anchorBounds.getMinX(), anchorBounds.getMaxY() + 5.0);
            } else {
                System.err.println("Error: Cannot show popup - invalid anchor or window.");
            }
            return;
        }
        this.optionsPopup.show(window, -10000.0, -10000.0);
        container.applyCss();
        container.layout();
        double popupWidth = container.getLayoutBounds().getWidth();
        double popupHeight = container.getLayoutBounds().getHeight();
        this.optionsPopup.hide();
        if (popupWidth <= 0.0 || popupHeight <= 0.0) {
            System.err.println("Warning: Popup dimensions are zero. Positioning might be incorrect.");
            popupWidth = container.prefWidth(-1.0);
            popupHeight = container.prefHeight(-1.0);
        }
        if ((stackPaneBounds = parentStackPane.localToScreen(parentStackPane.getBoundsInLocal())) == null) {
            System.err.println("Error: Could not get StackPane bounds. Cannot center popup.");
            Bounds anchorBounds = anchorNode.localToScreen(anchorNode.getBoundsInLocal());
            this.optionsPopup.show(window, anchorBounds.getMinX(), anchorBounds.getMaxY() + 5.0);
            return;
        }
        double centerX = stackPaneBounds.getMinX() + stackPaneBounds.getWidth() / 2.0 - popupWidth / 2.0;
        double bottomY = stackPaneBounds.getMaxY() - popupHeight - 20.0;
        this.optionsPopup.show(window, centerX, bottomY);
    }

    private StackPane findParentStackPane(Node node) {
        for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof StackPane)) continue;
            return (StackPane)parent;
        }
        if (node.getScene() != null && node.getScene().getRoot() instanceof StackPane) {
            return (StackPane)node.getScene().getRoot();
        }
        return null;
    }
}

