/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import javafx.geometry.Point2D;
import javafx.scene.image.Image;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceManager {
    private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
    private static ResourceManager instance;
    private final Map<String, Clip> audioCache = new HashMap<String, Clip>();
    private final Map<String, Image> imageCache = new HashMap<String, Image>();
    private final Map<String, Point2D> boardCoordinates = new HashMap<String, Point2D>();
    private boolean loadedRessources = false;

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public void playAudio(String audioName) {
        Clip clip = this.audioCache.get(audioName);
        if (clip == null) {
            errorLogger.error("Audio clip not found in cache for key: {}", (Object)audioName);
            return;
        }
        if (clip.isRunning()) {
            clip.stop();
        }
        clip.setFramePosition(0);
        clip.start();
    }

    public Image getImage(String fileName) {
        Image image = this.imageCache.get(fileName + ".png");
        if (image == null) {
            errorLogger.error("There is no image for {}", (Object)fileName);
            return null;
        }
        return this.imageCache.get(fileName + ".png");
    }

    public void preLoader() throws URISyntaxException, IOException {
        this.imageLoader("/images/cards", "/files.txt");
        try {
            this.audioLoader("/audios", "/files.txt");
        }
        catch (Exception e) {
            errorLogger.error("Failed to load audio resources.", (Throwable)e);
        }
    }

    public void audioLoader(String folderPath, String fileName) throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        InputStream is = this.getClass().getResourceAsStream(folderPath + fileName);
        if (is == null) {
            errorLogger.error("No audios folder found");
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String audioFile;
            while ((audioFile = reader.readLine()) != null) {
                String resourceName = folderPath + "/" + audioFile;
                InputStream audioStream = this.getClass().getResourceAsStream(resourceName);
                if (audioStream == null) {
                    errorLogger.error("Missing audio file: {}", (Object)resourceName);
                    continue;
                }
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(new BufferedInputStream(audioStream));
                Clip clip = AudioSystem.getClip();
                clip.open(inputStream);
                this.audioCache.put(audioFile, clip);
            }
            reader.close();
        }
        catch (IOException | LineUnavailableException e) {
            errorLogger.error("Audio error: {}", (Object)e.getMessage());
        }
    }

    public void imageLoader(String folderPath, String fileName) throws URISyntaxException, IOException {
        String imageName;
        InputStream is = this.getClass().getResourceAsStream(folderPath + fileName);
        if (is == null) {
            errorLogger.error("No cards folder found");
            return;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((imageName = reader.readLine()) != null) {
            String resourceName = folderPath + "/" + imageName;
            Image image = new Image(this.getClass().getResource(resourceName).toExternalForm(), false);
            this.imageCache.put(imageName.replace("_", ":"), image);
        }
        reader.close();
    }

    public Point2D getBoardCoordinates(String id) {
        return this.boardCoordinates.get(id);
    }
}

