/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models;

import ch.unibas.dmi.dbis.cs108.example.gui.javafx.Models.Model;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameEndNotification;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.Arrays;
import java.util.stream.Collectors;
import javafx.application.Platform;

public class WinModel {
    private static WinModel instance;
    private String winningTeamNames;
    private String losingTeamNames;

    private WinModel() {
    }

    public static WinModel getInstance() {
        if (instance == null) {
            instance = new WinModel();
        }
        return instance;
    }

    private String formatUserNames(User[] users) {
        return Arrays.stream(users).map(User::getNickname).collect(Collectors.joining(", "));
    }

    public void changeToWinScreen(GameEndNotification notification) {
        this.winningTeamNames = this.formatUserNames(notification.getWinningTeam());
        this.losingTeamNames = this.formatUserNames(notification.getLosingTeam());
        Platform.runLater(() -> Model.getInstance().getViewFactory().showWinScreen());
    }

    public String getWinningTeamNames() {
        return this.winningTeamNames;
    }

    public String getLosingTeamNames() {
        return this.losingTeamNames;
    }
}

