/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.protocol;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Collections;

public class Address {
    Integer port;
    String host;

    public Address(String host, Integer port) {
        this.host = host;
        this.port = port;
    }

    public Address(Integer port) throws UnknownHostException, SocketException {
        this.port = port;
        this.host = Address.findLocalIpAddress();
        System.out.println("Server is running on IP: " + this.host);
    }

    private static String findLocalIpAddress() throws SocketException {
        for (NetworkInterface iface : Collections.list(NetworkInterface.getNetworkInterfaces())) {
            if (iface.isLoopback() || !iface.isUp()) continue;
            for (InetAddress addr : Collections.list(iface.getInetAddresses())) {
                if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                return addr.getHostAddress();
            }
        }
        return "127.0.0.1";
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public static Address parseAddress(String address) throws UnknownHostException, SocketException {
        String[] parts = address.split(":");
        if (parts.length == 1) {
            return new Address(Integer.parseInt(parts[0]));
        }
        if (parts.length == 2) {
            return new Address(parts[0], Integer.parseInt(parts[1]));
        }
        throw new IllegalArgumentException("Invalid address: " + address);
    }
}

