/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.protocol;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Card;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Hand;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigurePositions;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.Arrays;
import java.util.Objects;

public class GameState {
    User[] players;
    User turn;
    Phase phase;
    FigurePositions[] allPositions;
    Hand[] hands;

    public GameState(User[] players, User turn, Phase phase, FigurePositions[] allPositions, Hand[] hands) {
        this.players = players;
        this.turn = turn;
        this.phase = phase;
        this.allPositions = allPositions;
        this.hands = hands;
    }

    public String toString() {
        StringBuilder encodedPlayersBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            encodedPlayersBuilder.append(this.players[i].getNickname());
            if (i == 3) continue;
            encodedPlayersBuilder.append(",");
        }
        String encodedPlayers = encodedPlayersBuilder.toString();
        String encodedTurn = this.turn.getNickname();
        String encodedPhase = this.phase.toString();
        StringBuilder encodedPositionsBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                encodedPositionsBuilder.append(this.allPositions[i].getPosAt(j));
                if (i == 3 && j == 3) continue;
                encodedPositionsBuilder.append(",");
            }
        }
        String encodedPositions = encodedPositionsBuilder.toString();
        StringBuilder encodedHandsBuilder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            int handSize = this.hands[i].cards.size();
            for (int j = 0; j < 6; ++j) {
                if (j < handSize) {
                    encodedHandsBuilder.append(this.hands[i].getCardAt(j).getSign().toString());
                    encodedHandsBuilder.append(":");
                    encodedHandsBuilder.append(this.hands[i].getCardAt(j).getValue().toString());
                } else {
                    encodedHandsBuilder.append(Card.Sign.NULLSIGN.toString());
                    encodedHandsBuilder.append(":");
                    encodedHandsBuilder.append(Card.Value.NULLVALUE.toString());
                }
                if (i == 3 && j == 5) continue;
                encodedHandsBuilder.append(",");
            }
        }
        String encodedHands = encodedHandsBuilder.toString();
        return encodedPlayers + ";" + encodedTurn + ";" + encodedPhase + ";" + encodedPositions + ";" + encodedHands;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GameState gameState = (GameState)obj;
        return Arrays.equals(this.players, gameState.players) && Objects.equals(this.turn, gameState.turn) && this.phase == gameState.phase && Arrays.equals(this.allPositions, gameState.allPositions) && Arrays.equals(this.hands, gameState.hands);
    }

    public User[] getPlayers() {
        return this.players;
    }

    public User getTurn() {
        return this.turn;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public FigurePositions[] getPositions() {
        return this.allPositions;
    }

    public Hand[] getHands() {
        return this.hands;
    }

    public void setTurn(User turn) {
        this.turn = turn;
    }

    public static enum Phase {
        PLAY,
        TRADE;

    }
}

