/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.protocol;

import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.Arrays;

public class LobbyInfo {
    public int lobbyID;
    public User[] players;
    public boolean isActive;
    public boolean isFinished;

    public LobbyInfo(int lobbyID, User[] players, boolean isActive, boolean isFinished) {
        this.lobbyID = lobbyID;
        this.players = players;
        this.isActive = isActive;
        this.isFinished = isFinished;
    }

    public boolean doesUserExist(String nickname) {
        return Arrays.asList(this.players).contains(new User(nickname));
    }

    public String toString() {
        StringBuilder encodedPlayersBuilder = new StringBuilder();
        for (int i = 0; i < this.players.length && this.players[i] != null; ++i) {
            if (encodedPlayersBuilder.length() > 0) {
                encodedPlayersBuilder.append(",");
            }
            encodedPlayersBuilder.append(this.players[i].getNickname());
        }
        return this.lobbyID + ":" + String.valueOf(encodedPlayersBuilder) + ":" + this.isActive + ":" + this.isFinished;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LobbyInfo that = (LobbyInfo)o;
        if (this.lobbyID != that.lobbyID) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.players[i].getNickname().equals(that.players[i].getNickname())) continue;
            return false;
        }
        if (this.isActive != that.isActive) {
            return false;
        }
        return this.isFinished == that.isFinished;
    }
}

