/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.protocol;

import ch.unibas.dmi.dbis.cs108.example.GuiChatContent;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Card;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.Hand;
import ch.unibas.dmi.dbis.cs108.example.protocol.AceMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChangeNickname;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChatContent;
import ch.unibas.dmi.dbis.cs108.example.protocol.CheatMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigurePositions;
import ch.unibas.dmi.dbis.cs108.example.protocol.FourMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameEndNotification;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameState;
import ch.unibas.dmi.dbis.cs108.example.protocol.JackMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.JokerMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.KingMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.LobbyInfo;
import ch.unibas.dmi.dbis.cs108.example.protocol.LoginMessage;
import ch.unibas.dmi.dbis.cs108.example.protocol.Move;
import ch.unibas.dmi.dbis.cs108.example.protocol.SevenMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.SimpleMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.SkipMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.TradeMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;

public class Protocol {
    public ProtocolType parseProtocol(String protocol) {
        String[] args = protocol.split(";");
        try {
            return ProtocolType.valueOf(args[0]);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Invalid protocol type: " + args[0], e);
        }
    }

    public ChangeNickname parseChangeNickname(String plzChangeNickname) {
        String[] args = plzChangeNickname.split(";");
        if (args.length != 3) {
            throw new RuntimeException("Invalid amount of arguments: " + plzChangeNickname);
        }
        String id = args[1];
        String newNickname = args[2];
        return new ChangeNickname(id, newNickname);
    }

    public String encodeLogout(LoginMessage message) {
        return "LOGOUT;" + message.getNickname() + ";" + message.getLobbyID();
    }

    public String encodeLogin(LoginMessage message) {
        return "LOGIN;" + message.getNickname() + ";" + message.getLobbyID();
    }

    public String encodeChangeNickname(ChangeNickname changeNickname) {
        return "CHANGE_NICKNAME;" + changeNickname.getOldNickname() + ";" + changeNickname.getNewNickname();
    }

    public String encodeLeaderBoard(Map<String, Integer> leaderboardMap) {
        if (leaderboardMap == null || leaderboardMap.isEmpty()) {
            return "";
        }
        return "LEADERBOARD;" + leaderboardMap.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(e -> (String)e.getKey() + "," + String.valueOf(e.getValue())).collect(Collectors.joining(";"));
    }

    public String parseLeaderBoard(String message) {
        String payload;
        if (message == null || message.isEmpty()) {
            return "";
        }
        int colonIdx = message.indexOf(59);
        if (colonIdx >= 0) {
            payload = message.substring(colonIdx + 1);
        } else {
            String[] parts = message.split(";");
            if (parts.length <= 1) {
                return "";
            }
            payload = String.join((CharSequence)";", Arrays.copyOfRange(parts, 1, parts.length));
        }
        return payload;
    }

    public ChatContent parseChat(String chat) {
        String[] args = chat.split(";");
        if (args.length != 4) {
            throw new RuntimeException("Invalid amount of arguments: " + chat);
        }
        String recipient = args[1];
        String sender = args[2];
        String message = args[3];
        return new ChatContent(recipient, sender, message);
    }

    public String encodeChat(ChatContent chat) {
        return "CHAT;" + chat.toString();
    }

    public User[] parsePlayers(String gameState) {
        String[] args = gameState.split(";");
        String[] users = args[1].split(",");
        if (users.length != 4) {
            throw new RuntimeException("Invalid amount of arguments: " + gameState);
        }
        User[] players = new User[4];
        for (int i = 0; i < 4; ++i) {
            players[i] = new User(users[i]);
        }
        return players;
    }

    public User parseTurn(String gameState) {
        String[] args = gameState.split(";");
        String turn = args[2];
        return new User(turn);
    }

    public GameState.Phase parsePhase(String gameState) {
        String[] args = gameState.split(";");
        String str = args[3];
        if (str.equals("PLAY")) {
            GameState.Phase phase = GameState.Phase.PLAY;
            return phase;
        }
        GameState.Phase phase = GameState.Phase.TRADE;
        return phase;
    }

    public FigurePositions[] parsePositions(String gameState) {
        String[] args = gameState.split(";");
        String[] positions = args[4].split(",");
        if (positions.length != 16) {
            throw new RuntimeException("Invalid amount of arguments: " + gameState);
        }
        Integer[] PosArray0 = new Integer[4];
        Integer[] PosArray1 = new Integer[4];
        Integer[] PosArray2 = new Integer[4];
        Integer[] PosArray3 = new Integer[4];
        for (int i = 0; i < 4; ++i) {
            PosArray0[i] = Integer.parseInt(positions[i]);
            PosArray1[i] = Integer.parseInt(positions[i + 4]);
            PosArray2[i] = Integer.parseInt(positions[i + 8]);
            PosArray3[i] = Integer.parseInt(positions[i + 12]);
        }
        User[] players = this.parsePlayers(gameState);
        return new FigurePositions[]{new FigurePositions(players[0], PosArray0), new FigurePositions(players[1], PosArray1), new FigurePositions(players[2], PosArray2), new FigurePositions(players[3], PosArray3)};
    }

    public Card parseCard(String card) {
        String[] type = card.split(":");
        Card.Sign s = Card.Sign.valueOf(type[0]);
        Card.Value v = Card.Value.valueOf(type[1]);
        return new Card(s, v);
    }

    public LoginMessage parseLoginMessage(String msg) {
        String[] parts = msg.split(";");
        if (parts.length != 3) {
            throw new RuntimeException("Invalid amount of arguments: " + msg);
        }
        return new LoginMessage(parts[1], Integer.parseInt(parts[2]));
    }

    public Hand[] parseHands(String gameState) {
        String[] args = gameState.split(";");
        String[] cards = args[5].split(",");
        if (cards.length != 24) {
            throw new RuntimeException("Invalid amount of arguments: " + gameState);
        }
        Card[] allCards = new Card[24];
        for (int i = 0; i < 24; ++i) {
            allCards[i] = this.parseCard(cards[i]);
        }
        Card[] cards0 = new Card[6];
        Card[] cards1 = new Card[6];
        Card[] cards2 = new Card[6];
        Card[] cards3 = new Card[6];
        for (int i = 0; i < 6; ++i) {
            cards0[i] = allCards[i];
            cards1[i] = allCards[i + 6];
            cards2[i] = allCards[i + 12];
            cards3[i] = allCards[i + 18];
        }
        cards0 = (Card[])Arrays.stream(cards0).filter(c -> c.getSign() != Card.Sign.NULLSIGN).toArray(Card[]::new);
        cards1 = (Card[])Arrays.stream(cards1).filter(c -> c.getSign() != Card.Sign.NULLSIGN).toArray(Card[]::new);
        cards2 = (Card[])Arrays.stream(cards2).filter(c -> c.getSign() != Card.Sign.NULLSIGN).toArray(Card[]::new);
        cards3 = (Card[])Arrays.stream(cards3).filter(c -> c.getSign() != Card.Sign.NULLSIGN).toArray(Card[]::new);
        User[] players = this.parsePlayers(gameState);
        return new Hand[]{new Hand(players[0], cards0), new Hand(players[1], cards1), new Hand(players[2], cards2), new Hand(players[3], cards3)};
    }

    public GameState parseGameState(String gameState) {
        String[] args = gameState.split(";");
        if (args.length != 6) {
            throw new RuntimeException("Invalid amount of arguments: " + gameState);
        }
        User[] players = this.parsePlayers(gameState);
        User turn = this.parseTurn(gameState);
        GameState.Phase phase = this.parsePhase(gameState);
        FigurePositions[] positions = this.parsePositions(gameState);
        Hand[] hands = this.parseHands(gameState);
        return new GameState(players, turn, phase, positions, hands);
    }

    public String encodeGameState(GameState gameState) {
        return "STATE;" + gameState.toString();
    }

    public Card parseTrade(String trade) {
        String[] args = trade.split(";");
        if (args.length != 2) {
            throw new RuntimeException("Invalid amount of arguments: " + trade);
        }
        return this.parseCard(args[1]);
    }

    public String encodeTrade(Card trade) {
        return "TRADE;" + trade.toString();
    }

    public Move parseMove(String move) {
        String[] args = move.split(";");
        if (args[1].equals("SEVEN")) {
            SevenMove sevenMove = SevenMove.fromString(args[2]);
            return sevenMove;
        }
        if (args[1].equals("TRADE")) {
            String[] desiredCardString = args[2].split(":");
            Card desiredCard = new Card(Card.Sign.valueOf(desiredCardString[0]), Card.Value.valueOf(desiredCardString[1]));
            return new TradeMove(desiredCard);
        }
        String[] cardString = args[1].split(":");
        String signString = cardString[0];
        if (signString.equals("CHEAT")) {
            return new CheatMove();
        }
        Card.Value parsedValue = Card.Value.valueOf(cardString[1]);
        Card.Sign sign = Card.Sign.valueOf(signString);
        if (parsedValue == Card.Value.JOKERVALUE) {
            String[] desiredCardString = args[2].split(":");
            Card desiredCard = new Card(Card.Sign.valueOf(desiredCardString[0]), Card.Value.valueOf(desiredCardString[1]));
            return new JokerMove(desiredCard);
        }
        int figure = Integer.parseInt(args[2]);
        return switch (cardString[1]) {
            case "ACE" -> new AceMove(new Card(sign, Card.Value.ACE), figure, Integer.parseInt(args[3]));
            case "KING" -> new KingMove(new Card(sign, Card.Value.KING), figure, Integer.parseInt(args[3]));
            case "FOUR" -> new FourMove(new Card(sign, Card.Value.FOUR), figure, FourMove.Direction.valueOf(args[3]));
            case "JACK" -> new JackMove(new Card(sign, Card.Value.JACK), figure, Integer.parseInt(args[3]));
            case "NULLVALUE" -> new SkipMove();
            default -> new SimpleMove(new Card(Card.Sign.valueOf(cardString[0]), Card.Value.valueOf(cardString[1])), figure);
        };
    }

    public String encodeGameEndNotification(GameEndNotification gameEndNotification) {
        return "GAME_END_NOTIFICATION;" + gameEndNotification.toString();
    }

    public GameEndNotification parseGameEndNotification(String gameEndNotification) {
        String[] args = gameEndNotification.split(";");
        String winnersString = args[1];
        User[] winners = (User[])Arrays.stream(winnersString.split(",")).map(User::new).toArray(User[]::new);
        String usersString = args[2];
        User[] losers = (User[])Arrays.stream(usersString.split(",")).map(User::new).toArray(User[]::new);
        return new GameEndNotification(winners, losers);
    }

    public String encodeMove(Move move) {
        if (move instanceof SevenMove) {
            return "MOVE;SEVEN;" + move.toString();
        }
        return "MOVE;" + move.toString();
    }

    public GuiChatContent parseGuiChat(String guiChat, String sender, Optional<Integer> lobbyId) {
        if ((guiChat = guiChat.trim()).contains("/")) {
            String recipient;
            int index = guiChat.indexOf("/") + 1;
            int endIndex = guiChat.indexOf(" ", index);
            if (endIndex == -1) {
                endIndex = guiChat.length();
            }
            if ((recipient = guiChat.substring(index, endIndex)).equals("all")) {
                recipient = "ALL";
            }
            String message = guiChat.substring(endIndex + 1);
            return new GuiChatContent(recipient, message, sender);
        }
        Object recipient = "ALL";
        if (lobbyId.isPresent()) {
            recipient = "LOBBY" + String.valueOf(lobbyId.get());
        }
        return new GuiChatContent((String)recipient, guiChat.trim(), sender);
    }

    public String encodeGuiChatContent(GuiChatContent guiChatContent) {
        return "CHAT;" + guiChatContent.toString();
    }

    public GuiChatContent GuiParseChatDisplay(String chat) {
        String[] args = chat.split(";");
        if (args.length != 4) {
            throw new RuntimeException("Invalid amount of arguments: " + chat);
        }
        String recipient = args[1];
        String sender = args[2];
        String message = args[3];
        return new GuiChatContent(recipient, message, sender);
    }

    public String encodePing() {
        return "PING;";
    }

    public String encodePong() {
        return "PONG;";
    }

    public LobbyInfo[] parseLobbyInfo(String getLobbyInfo) {
        String[] parts = getLobbyInfo.split(";");
        String[] lobbyStrings = Arrays.copyOfRange(parts, 1, parts.length);
        Vector<LobbyInfo> lobbyInfos = new Vector<LobbyInfo>();
        for (int i = 0; i < lobbyStrings.length; ++i) {
            String[] pair = lobbyStrings[i].split(":");
            String[] userStrings = pair[1].split(",");
            Vector<User> users = new Vector<User>();
            for (int j = 0; j < userStrings.length; ++j) {
                if (userStrings[j].equals("")) continue;
                users.add(new User(userStrings[j]));
            }
            LobbyInfo newLobbyinfo = new LobbyInfo(Integer.parseInt(pair[0]), users.toArray(new User[0]), Boolean.parseBoolean(pair[2]), Boolean.parseBoolean(pair[3]));
            lobbyInfos.add(newLobbyinfo);
        }
        return lobbyInfos.toArray(new LobbyInfo[0]);
    }

    public String encodeLobbyInfoGiver(LobbyInfo[] allLobbyInfos) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < allLobbyInfos.length; ++i) {
            stringBuilder.append(allLobbyInfos[i].toString());
            if (i >= allLobbyInfos.length - 1) continue;
            stringBuilder.append(";");
        }
        return "GIVE_LOBBYINFO;" + stringBuilder.toString();
    }

    public String encodeLobbyInfoRequester() {
        return "GET_LOBBYINFO;";
    }

    public static enum ProtocolType {
        CHAT,
        LOGIN,
        LOGOUT,
        CHANGE_NICKNAME,
        MOVE,
        STATE,
        TRADE,
        PING,
        PONG,
        GET_LOBBYINFO,
        GIVE_LOBBYINFO,
        LEADERBOARD,
        GAME_END_NOTIFICATION;

    }
}

