/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.protocol;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Card;
import ch.unibas.dmi.dbis.cs108.example.protocol.FigureMove;
import ch.unibas.dmi.dbis.cs108.example.protocol.Move;
import java.util.Optional;
import java.util.Vector;
import java.util.stream.Collectors;

public class SevenMove
extends Move {
    Vector<FigureMove> figureMoves;

    public SevenMove(Vector<FigureMove> figureMoves) {
        this.card = new Card(Card.Sign.DIAMOND, Card.Value.SEVEN);
        this.figure = -1;
        this.figureMoves = figureMoves;
    }

    public static SevenMove fromString(String sevenString) {
        Vector<FigureMove> figureMoves = new Vector<FigureMove>();
        if (sevenString.isEmpty()) {
            return new SevenMove(figureMoves);
        }
        String[] figuresWithMoves = sevenString.split(",");
        Integer accumulatedMoves = 0;
        for (String figureMove : figuresWithMoves) {
            String[] split = figureMove.split(":");
            if (split.length != 2) {
                throw new RuntimeException("SevenMove string must contain two fields separated by ;");
            }
            Integer figure = Integer.parseInt(split[0]);
            Integer moves = Integer.parseInt(split[1]);
            figureMoves.add(new FigureMove(figure, moves));
            accumulatedMoves = accumulatedMoves + moves;
        }
        if (accumulatedMoves != 7) {
            throw new RuntimeException("SevenMove needs exactly 7 moves - otherwise it's wrong!");
        }
        return new SevenMove(figureMoves);
    }

    @Override
    public Optional<Integer> desiredMoves() {
        return Optional.empty();
    }

    public Vector<FigureMove> getFigureMoves() {
        return this.figureMoves;
    }

    @Override
    public String toString() {
        return this.figureMoves.stream().map(FigureMove::toString).collect(Collectors.joining(","));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SevenMove) {
            SevenMove sm = (SevenMove)obj;
            return sm.figureMoves.equals(this.figureMoves);
        }
        return false;
    }
}

