/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.NicknameHelper;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChatContent;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import ch.unibas.dmi.dbis.cs108.example.server.LobbyHelper;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChatThread
implements Runnable {
    private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");
    private final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;
    private final ConcurrentHashMap<String, Integer> loggedInUsers;
    private final BlockingQueue<ChatContent> chatQueue;
    private final ConcurrentHashMap<String, Integer> nicknamesToLobbyId;

    public ChatThread(ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues, BlockingQueue<ChatContent> chatQueue, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<String, Integer> nicknamesToLobbyId) {
        this.userQueues = userQueues;
        this.chatQueue = chatQueue;
        this.loggedInUsers = loggedInUsers;
        this.nicknamesToLobbyId = nicknamesToLobbyId;
    }

    private void log(String message) {
        generalLogger.info("[CHAT THREAD] " + message);
    }

    @Override
    public void run() {
        try {
            Protocol p = new Protocol();
            block2: while (true) {
                ChatContent chatContent = this.chatQueue.take();
                generalLogger.info("Receive chat message: " + String.valueOf(chatContent));
                String recipient = chatContent.getRecipient();
                if (recipient.contains("ALL")) {
                    generalLogger.info("Broadcast: " + String.valueOf(chatContent));
                    Iterator<Map.Entry<String, Integer>> iterator = this.loggedInUsers.entrySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        Map.Entry<String, Integer> entry = iterator.next();
                        if (entry.getKey().equals(chatContent.getSender())) continue;
                        this.userQueues.get(entry.getValue()).put(p.encodeChat(chatContent));
                    }
                }
                if (recipient.contains("LOBBY")) {
                    Integer lobbyId = LobbyHelper.parseLobbyId(recipient);
                    if (lobbyId == null) continue;
                    generalLogger.info("Lobby: " + String.valueOf(chatContent));
                    List<BlockingQueue> queues = LobbyHelper.getNicknamesFromLobbyId(this.nicknamesToLobbyId, lobbyId).stream().filter(nickname -> !nickname.equals(chatContent.sender)).map(nickname -> NicknameHelper.getQueueByNickname(nickname, this.userQueues, this.loggedInUsers)).toList();
                    queues.forEach(queue -> {
                        try {
                            queue.put(p.encodeChat(chatContent));
                        }
                        catch (InterruptedException e) {
                            generalLogger.info("Sending the lobby message did not work: " + String.valueOf(chatContent));
                            throw new RuntimeException(e);
                        }
                    });
                    continue;
                }
                Integer loggedInUser = this.loggedInUsers.get(recipient);
                if (loggedInUser == null) continue;
                this.userQueues.get(loggedInUser).put(p.encodeChat(chatContent));
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

