/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChatContent;
import ch.unibas.dmi.dbis.cs108.example.protocol.MoveWithMetaInformation;
import ch.unibas.dmi.dbis.cs108.example.server.ClientPingTimer;
import ch.unibas.dmi.dbis.cs108.example.server.ClientReadThread;
import ch.unibas.dmi.dbis.cs108.example.server.ClientWriteThread;
import ch.unibas.dmi.dbis.cs108.example.server.LeaderBoardManager;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class ClientInfos {
    ClientReadThread readThread;
    ClientWriteThread writeThread;
    Socket socket;

    public ClientInfos(ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues, ConcurrentHashMap<String, Integer> loggedInUsers, Socket socket, BlockingQueue<MoveWithMetaInformation> gameQueue, BlockingQueue<ChatContent> chatQueue, ClientPingTimer pingTimer, ConcurrentHashMap<Integer, Game> games, ConcurrentHashMap<String, Integer> nicknameToLobbyId, LeaderBoardManager leaderBoardManager) {
        LinkedBlockingQueue<String> messageQueue = new LinkedBlockingQueue<String>();
        this.socket = socket;
        this.writeThread = new ClientWriteThread(messageQueue, this.socket);
        this.readThread = new ClientReadThread(gameQueue, chatQueue, messageQueue, this.socket, loggedInUsers, pingTimer, games, nicknameToLobbyId, leaderBoardManager, userQueues);
        userQueues.put(socket.getPort(), messageQueue);
    }

    public void stopAndFreeRessourcesFromClient() {
        this.readThread.stop();
        this.writeThread.stop();
        try {
            if (!this.socket.isClosed()) {
                System.out.println("We are ending the socket!");
                this.socket.close();
            }
        }
        catch (IOException e) {
            System.out.println("Could not close the socket!");
            throw new RuntimeException(e);
        }
    }

    public void start() {
        Thread.startVirtualThread(this.readThread);
        Thread.startVirtualThread(this.writeThread);
    }

    public void close() throws IOException {
        this.socket.close();
    }
}

