/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.NicknameHelper;
import ch.unibas.dmi.dbis.cs108.example.server.ClientInfos;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class ClientPingTimer {
    public Timer clientPingTimer = new Timer();
    private final ConcurrentHashMap<Integer, ClientInfos> clients;
    private final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;
    private final ConcurrentHashMap<String, Integer> loggedInUsers;
    private final ConcurrentHashMap<String, Integer> nicknamesToLobbyId;
    private final Integer clientPort;

    public ClientPingTimer(Integer clientPort, ConcurrentHashMap<Integer, ClientInfos> clients, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues, ConcurrentHashMap<String, Integer> nicknamesToLobbyId) {
        this.clientPort = clientPort;
        this.loggedInUsers = loggedInUsers;
        this.clients = clients;
        this.userQueues = userQueues;
        this.nicknamesToLobbyId = nicknamesToLobbyId;
    }

    public void startPingTimer() {
        this.clientPingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                System.out.println("The client is not responding.");
                System.out.println("We are freeing this client's resources.");
                ClientPingTimer.this.freeRessourcesFromClient();
            }
        }, 30000L);
    }

    private String findCurrentNicknameOfClientPort(Integer clientPort) {
        return NicknameHelper.getCurrentNicknameFromPort(clientPort, this.loggedInUsers);
    }

    private void freeRessourcesFromClient() {
        System.out.println("Logging out the client");
        String clientNickname = this.findCurrentNicknameOfClientPort(this.clientPort);
        if (clientNickname != null) {
            this.loggedInUsers.remove(clientNickname);
            System.out.println("Successfully logged out with nickname: " + clientNickname);
            this.nicknamesToLobbyId.remove(clientNickname);
            System.out.println("Successfully removed from lobby " + clientNickname);
        }
        System.out.println("Stopping client threads");
        ClientInfos infos = this.clients.remove(this.clientPort);
        if (infos != null) {
            infos.stopAndFreeRessourcesFromClient();
        }
        System.out.println("We remove the client queues");
        this.userQueues.remove(this.clientPort);
        System.out.println("Client was removed");
    }

    public void resetPingTimer() {
        this.clientPingTimer.cancel();
        this.clientPingTimer.purge();
        this.clientPingTimer = new Timer();
    }
}

