/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.NicknameHelper;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChangeNickname;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChatContent;
import ch.unibas.dmi.dbis.cs108.example.protocol.LoginMessage;
import ch.unibas.dmi.dbis.cs108.example.protocol.Move;
import ch.unibas.dmi.dbis.cs108.example.protocol.MoveWithMetaInformation;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import ch.unibas.dmi.dbis.cs108.example.server.ClientPingTimer;
import ch.unibas.dmi.dbis.cs108.example.server.GameServer;
import ch.unibas.dmi.dbis.cs108.example.server.LeaderBoardManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientReadThread
implements Runnable {
    private final BlockingQueue<MoveWithMetaInformation> gameQueue;
    private final BlockingQueue<ChatContent> chatQueue;
    private final BlockingQueue<String> messageQueue;
    private final Socket socket;
    private volatile boolean stopped = false;
    private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");
    private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
    ClientPingTimer pingTimer;
    ConcurrentHashMap<String, Integer> loggedInUsers;
    ConcurrentHashMap<Integer, Game> games;
    ConcurrentHashMap<String, Integer> nicknameToLobbyId = new ConcurrentHashMap();
    LeaderBoardManager leaderBoardManager;
    ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;

    public ClientReadThread(BlockingQueue<MoveWithMetaInformation> gameQueue, BlockingQueue<ChatContent> chatQueue, BlockingQueue<String> messageQueue, Socket socket, ConcurrentHashMap<String, Integer> loggedInUsers, ClientPingTimer pingTimer, ConcurrentHashMap<Integer, Game> games, ConcurrentHashMap<String, Integer> nicknameToLobbyId, LeaderBoardManager leaderBoardManager, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues) {
        this.gameQueue = gameQueue;
        this.chatQueue = chatQueue;
        this.socket = socket;
        this.messageQueue = messageQueue;
        this.loggedInUsers = loggedInUsers;
        this.pingTimer = pingTimer;
        this.games = games;
        this.nicknameToLobbyId = nicknameToLobbyId;
        this.leaderBoardManager = leaderBoardManager;
        this.userQueues = userQueues;
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    public void run() {
        try {
            this.pingTimer.startPingTimer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
            while (!this.stopped) {
                Integer lobbyId;
                String nickname;
                Object message;
                String messageFromClient = reader.readLine();
                if (messageFromClient == null) continue;
                Protocol p = new Protocol();
                Protocol.ProtocolType pType = p.parseProtocol(messageFromClient);
                if (pType == Protocol.ProtocolType.CHAT) {
                    ChatContent chatContent = p.parseChat(messageFromClient);
                    this.chatQueue.put(chatContent);
                    continue;
                }
                if (pType == Protocol.ProtocolType.LOGIN) {
                    message = p.parseLoginMessage(messageFromClient);
                    generalLogger.info("Have received a login message: {}", (Object)message.toString());
                    nickname = NicknameHelper.makeNameUnique(((LoginMessage)message).getNickname(), this.loggedInUsers);
                    this.loggedInUsers.put(nickname, this.socket.getPort());
                    generalLogger.info("We have registered a new user with nickname {}", (Object)nickname);
                    Integer lobbyIDWish = ((LoginMessage)message).getLobbyID();
                    LoginMessage response = new LoginMessage(nickname, lobbyIDWish);
                    boolean lobbyExists = false;
                    if (lobbyIDWish != 10000) {
                        for (Object lobbyID : this.games.keySet()) {
                            if (!((Integer)lobbyID).equals(lobbyIDWish)) continue;
                            lobbyExists = true;
                            break;
                        }
                    }
                    if (lobbyExists) {
                        this.games.get(lobbyIDWish).addWaitingPlayer(nickname);
                        generalLogger.info("Player {} wants to join Lobby {}", (Object)nickname, (Object)lobbyIDWish);
                        this.nicknameToLobbyId.put(nickname, lobbyIDWish);
                    } else if (lobbyIDWish == 10000) {
                        generalLogger.info("Player {} wants to join a random lobby", (Object)nickname);
                        boolean emptySpotsleft = false;
                        if (!this.games.isEmpty()) {
                            Object lobbyID;
                            lobbyID = this.games.values().iterator();
                            while (lobbyID.hasNext()) {
                                Game game = (Game)lobbyID.next();
                                if (game.isActive() || game.numberOfPlayers() >= 4) continue;
                                emptySpotsleft = true;
                            }
                        }
                        if (!emptySpotsleft) {
                            Game game = new Game((Integer)GameServer.generateLobbyID(), this.leaderBoardManager);
                            this.games.put(game.getLobbyID(), game);
                            game.addWaitingPlayer(nickname);
                            this.nicknameToLobbyId.put(nickname, game.getLobbyID());
                        } else {
                            for (Game game : this.games.values()) {
                                if (game.numberOfPlayers() >= 4 || game.isActive()) continue;
                                game.addWaitingPlayer(nickname);
                                this.nicknameToLobbyId.put(nickname, game.getLobbyID());
                                break;
                            }
                        }
                    } else {
                        generalLogger.info("Player {} wants to create a new Lobby. Lobby with ID {} is being created.", (Object)nickname, (Object)lobbyIDWish);
                        Game game = new Game(lobbyIDWish, this.leaderBoardManager);
                        game.addWaitingPlayer(nickname);
                        this.games.put(game.getLobbyID(), game);
                        this.nicknameToLobbyId.put(nickname, game.getLobbyID());
                    }
                    try {
                        this.messageQueue.put(p.encodeLogin(response));
                    }
                    catch (InterruptedException e) {
                        errorLogger.error("An error occurred while processing the game: {}", (Object)e.getMessage());
                    }
                    continue;
                }
                if (pType == Protocol.ProtocolType.MOVE) {
                    Move move = p.parseMove(messageFromClient);
                    String currentNickname = NicknameHelper.getCurrentNicknameFromPort(this.socket.getPort(), this.loggedInUsers);
                    lobbyId = this.nicknameToLobbyId.get(currentNickname);
                    MoveWithMetaInformation metaMove = new MoveWithMetaInformation(move, currentNickname, lobbyId);
                    this.gameQueue.put(metaMove);
                    continue;
                }
                if (pType == Protocol.ProtocolType.LOGOUT) {
                    message = p.parseLoginMessage(messageFromClient);
                    nickname = ((LoginMessage)message).getNickname();
                    lobbyId = this.nicknameToLobbyId.get(nickname);
                    if (lobbyId != null) {
                        Game game = this.games.get(lobbyId);
                        if (!game.isActive()) {
                            User toBeRemoved = new User(((LoginMessage)message).getNickname());
                            this.games.get(this.nicknameToLobbyId.get(((LoginMessage)message).getNickname())).removeWaitingUser(toBeRemoved);
                        } else {
                            game.setGamePreemptivelyFinished();
                        }
                    }
                    this.loggedInUsers.remove(((LoginMessage)message).getNickname());
                    generalLogger.info("[LOGOUT] Logout of {}", (Object)((LoginMessage)message).getNickname());
                    continue;
                }
                if (pType == Protocol.ProtocolType.CHANGE_NICKNAME) {
                    message = p.parseChangeNickname(messageFromClient);
                    ChangeNickname updatedChangeNickname = NicknameHelper.changeNickname((ChangeNickname)message, this.loggedInUsers, this.nicknameToLobbyId, this.games);
                    generalLogger.info("[CHANGE_NICKNAME] Change of Nicknames from {} to {}", (Object)updatedChangeNickname.getOldNickname(), (Object)updatedChangeNickname.getNewNickname());
                    this.messageQueue.put(p.encodeChangeNickname(updatedChangeNickname));
                    continue;
                }
                if (pType == Protocol.ProtocolType.PING) {
                    generalLogger.info("[PING] Ping received");
                    this.pingTimer.resetPingTimer();
                    this.pingTimer.startPingTimer();
                    this.messageQueue.put("PONG;");
                    System.out.println("Pong sent");
                    continue;
                }
                if (pType != Protocol.ProtocolType.GET_LOBBYINFO) continue;
                this.messageQueue.put(p.encodeLobbyInfoGiver(GameServer.getLobbyInfoArray()));
            }
        }
        catch (IOException e) {
            errorLogger.error("Client with port: {} was terminated.", (Object)this.socket.getPort());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

