/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientWriteThread
implements Runnable {
    private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");
    private final BlockingQueue<String> messageQueue;
    private final Socket socket;
    private volatile boolean stopped = false;

    public ClientWriteThread(BlockingQueue<String> messageQueue, Socket socket) {
        this.messageQueue = messageQueue;
        this.socket = socket;
    }

    public void stop() {
        this.stopped = true;
    }

    @Override
    public void run() {
        try {
            while (!this.stopped) {
                String message = this.messageQueue.take();
                this.sendMessageToClient(message);
            }
        }
        catch (IOException | InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void sendMessageToClient(String message) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream()));
        generalLogger.info("[SEND_MESSAGE] sending message to client: {}", (Object)message);
        out.write(message + "\r\n");
        out.flush();
    }
}

