/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.server.GameStateSender;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameEndingThread
implements Runnable {
    private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
    private final ConcurrentHashMap<String, Integer> loggedInUsers;
    private final ConcurrentHashMap<Integer, Game> games;
    private final ConcurrentHashMap<String, Integer> nicknamesToLobbyId;
    private final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;

    GameEndingThread(ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, Game> games, ConcurrentHashMap<String, Integer> nicknamesToLobbyId, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues) {
        this.loggedInUsers = loggedInUsers;
        this.games = games;
        this.nicknamesToLobbyId = nicknamesToLobbyId;
        this.userQueues = userQueues;
    }

    @Override
    public void run() {
        block4: while (true) {
            Iterator<Game> iterator = this.games.values().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                Game game = iterator.next();
                if (game.isFinished() && !game.usersHaveBeenKicked()) {
                    GameStateSender.sendGameEndNotificationToLobby(game, this.loggedInUsers, this.userQueues);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        errorLogger.error("[GameEndingThread]: Thread sleep interrupted!");
                        throw new RuntimeException(e);
                    }
                    System.out.println("The lobby number " + game.getLobbyID() + " has been finished. Players will be logged out.");
                    for (String player : game.getPlayerNicknames()) {
                        this.nicknamesToLobbyId.remove(player);
                        this.loggedInUsers.remove(player);
                    }
                    game.setUsersKicked();
                }
                Integer gameId = game.getLobbyID();
                long lobbySize = this.nicknamesToLobbyId.values().stream().filter(lobbyId -> lobbyId.equals(gameId)).count();
                if (lobbySize == 4L) continue;
                if (game.isActive() && !game.isFinished()) {
                    game.setGamePreemptivelyFinished();
                }
                if (game.isActive() || lobbySize == (long)game.getWaitingUsersCount()) continue;
                if (lobbySize != (long)game.getWaitingUsersCount()) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        errorLogger.error("[GameEndingThread]: Thread sleep interrupted!");
                        throw new RuntimeException(e);
                    }
                }
                if ((lobbySize = this.nicknamesToLobbyId.values().stream().filter(lobbyId -> lobbyId.equals(gameId)).count()) == (long)game.getWaitingUsersCount()) continue;
                game.setGamePreemptivelyFinished();
            }
            break;
        }
    }
}

