/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.protocol.Address;
import ch.unibas.dmi.dbis.cs108.example.protocol.ChatContent;
import ch.unibas.dmi.dbis.cs108.example.protocol.LobbyInfo;
import ch.unibas.dmi.dbis.cs108.example.protocol.MoveWithMetaInformation;
import ch.unibas.dmi.dbis.cs108.example.server.ChatThread;
import ch.unibas.dmi.dbis.cs108.example.server.ClientInfos;
import ch.unibas.dmi.dbis.cs108.example.server.ClientPingTimer;
import ch.unibas.dmi.dbis.cs108.example.server.GameEndingThread;
import ch.unibas.dmi.dbis.cs108.example.server.GameThread;
import ch.unibas.dmi.dbis.cs108.example.server.LeaderBoardManager;
import ch.unibas.dmi.dbis.cs108.example.server.LeaderboardInfoThread;
import ch.unibas.dmi.dbis.cs108.example.server.LobbyActivatorThread;
import ch.unibas.dmi.dbis.cs108.example.server.LobbyInfoDispatcherThread;
import ch.unibas.dmi.dbis.cs108.example.server.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;

public class GameServer {
    private static final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Integer> loggedInUsers = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, ClientInfos> clients = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Integer, Game> games = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Integer> nicknameToLobbyId = new ConcurrentHashMap();
    private static final BlockingQueue<MoveWithMetaInformation> gameQueue = new LinkedBlockingQueue<MoveWithMetaInformation>();
    private static final BlockingQueue<ChatContent> chatQueue = new LinkedBlockingQueue<ChatContent>();
    private static final LeaderBoardManager leaderBoardManager = new LeaderBoardManager(LeaderBoardManager.suggestedPath());

    public static void main(String[] args) throws IOException {
        ChatThread chatThread = new ChatThread(userQueues, chatQueue, loggedInUsers, nicknameToLobbyId);
        GameThread gameThread = new GameThread(userQueues, gameQueue, loggedInUsers, games);
        LobbyActivatorThread lobbyActivatorThread = new LobbyActivatorThread(games, loggedInUsers, userQueues);
        GameEndingThread gameEndingThread = new GameEndingThread(loggedInUsers, games, nicknameToLobbyId, userQueues);
        LobbyInfoDispatcherThread lobbyInfoDispatcherThread = new LobbyInfoDispatcherThread(userQueues, clients, games);
        LeaderboardInfoThread leaderboardInfoThread = new LeaderboardInfoThread(userQueues, clients, leaderBoardManager);
        Thread.startVirtualThread(chatThread);
        Thread.startVirtualThread(gameThread);
        Thread.startVirtualThread(lobbyActivatorThread);
        Thread.startVirtualThread(gameEndingThread);
        Thread.startVirtualThread(lobbyInfoDispatcherThread);
        Thread.startVirtualThread(leaderboardInfoThread);
        leaderBoardManager.createHighscoreDatabaseIfNotExisting();
        leaderBoardManager.loadFromFile();
        if (args.length != 1) {
            throw new IllegalArgumentException("Usage: java GameServer <IP-Address>:<Port>");
        }
        Address address = Address.parseAddress(args[0]);
        System.out.println("Waiting for connections on " + address.getHost() + ":" + address.getPort() + "...");
        ServerSocket echod = new ServerSocket(address.getPort(), 50, InetAddress.getByName(address.getHost()));
        while (true) {
            Socket socket = echod.accept();
            Integer clientPort = socket.getPort();
            GameServer.addClient(clientPort, gameQueue, chatQueue, socket, loggedInUsers, clients);
        }
    }

    public static void addClient(Integer clientPort, BlockingQueue<MoveWithMetaInformation> gameQueue, BlockingQueue<ChatContent> chatQueue, Socket socket, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, ClientInfos> clients) {
        ClientPingTimer pingTimer = new ClientPingTimer(clientPort, clients, loggedInUsers, userQueues, nicknameToLobbyId);
        ClientInfos clientInfos = new ClientInfos(userQueues, loggedInUsers, socket, gameQueue, chatQueue, pingTimer, games, nicknameToLobbyId, leaderBoardManager);
        clients.put(clientPort, clientInfos);
        clients.get(clientPort).start();
        Log.log("New ClientInfos added: " + socket.getRemoteSocketAddress().toString());
    }

    public static LobbyInfo[] getLobbyInfoArray() {
        if (games.isEmpty()) {
            return new LobbyInfo[0];
        }
        int numberOfLobbies = games.size();
        LobbyInfo[] lobbyInfos = new LobbyInfo[numberOfLobbies];
        int arrIndex = 0;
        for (Game game : games.values()) {
            lobbyInfos[arrIndex] = game.toLobbyInfo();
            ++arrIndex;
        }
        return lobbyInfos;
    }

    public static int generateLobbyID() {
        int lobbyID = (int)(Math.random() * 9000.0) + 1000;
        while (games.containsKey(lobbyID)) {
            lobbyID = GameServer.generateLobbyID();
        }
        return lobbyID;
    }
}

