/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.gameLogic.NicknameHelper;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameEndNotification;
import ch.unibas.dmi.dbis.cs108.example.protocol.GameState;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameStateSender {
    private static final Logger generalLogger = LogManager.getLogger("GeneralLogger");

    public static void sendGameStateToLobby(Game game, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues) {
        List<BlockingQueue<String>> queues = GameStateSender.getBlockingQueues(game, loggedInUsers, userQueues);
        generalLogger.info("[GameThread] Sending out GameState to all players in the lobby.");
        Protocol p = new Protocol();
        GameState newGameState = game.getGameState();
        String encodedGameState = p.encodeGameState(newGameState);
        queues.forEach(queue -> {
            try {
                queue.put(encodedGameState);
            }
            catch (InterruptedException e) {
                generalLogger.error("[GameThread] Message with the new GameState could not be sent!");
            }
        });
    }

    public static void sendGameEndNotificationToLobby(Game game, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues) {
        Optional<GameEndNotification> maybeGameEndNotification = game.createGameEndNotification();
        if (maybeGameEndNotification.isEmpty()) {
            return;
        }
        List<BlockingQueue<String>> queues = GameStateSender.getBlockingQueues(game, loggedInUsers, userQueues);
        generalLogger.info("[GameThread] Game is finished. Sending out GameEndNotification.");
        Protocol p = new Protocol();
        String encodedGameState = p.encodeGameEndNotification(maybeGameEndNotification.get());
        queues.forEach(queue -> {
            try {
                if (queue != null) {
                    queue.put(encodedGameState);
                }
            }
            catch (InterruptedException e) {
                generalLogger.error("[GameThread] GameEndNotification could not be sent!");
            }
        });
    }

    private static List<BlockingQueue<String>> getBlockingQueues(Game game, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues) {
        String[] usersInThisGame = game.getPlayerNicknames();
        List<BlockingQueue<String>> queues = Arrays.stream(usersInThisGame).map(name -> NicknameHelper.getQueueByNickname(name, userQueues, loggedInUsers)).toList();
        return queues;
    }
}

