/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.protocol.MoveWithMetaInformation;
import ch.unibas.dmi.dbis.cs108.example.server.GameStateSender;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(GameThread.class);
    private final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;
    private final BlockingQueue<MoveWithMetaInformation> gameQueue;
    private final ConcurrentHashMap<String, Integer> loggedInUsers;
    private final ConcurrentHashMap<Integer, Game> games;

    public GameThread(ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues, BlockingQueue<MoveWithMetaInformation> gameQueue, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, Game> games) {
        this.userQueues = userQueues;
        this.gameQueue = gameQueue;
        this.loggedInUsers = loggedInUsers;
        this.games = games;
    }

    @Override
    public void run() {
        try {
            while (true) {
                MoveWithMetaInformation currentMove = this.gameQueue.take();
                Game game = this.games.get(currentMove.getGameId());
                game.proceedGame(currentMove);
                GameStateSender.sendGameStateToLobby(game, this.loggedInUsers, this.userQueues);
                logger.info("[GameThread] Game state distributed! Game ID: {}", (Object)currentMove.getGameId());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

