/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.protocol.User;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LeaderBoardManager {
    private static final Logger errorLogger = LogManager.getLogger("ErrorLogger");
    Path highscoreDbPath;
    private final ConcurrentHashMap<String, Integer> board = new ConcurrentHashMap();

    public static Path suggestedPath() {
        String USER_DIR_SUBPATH = "/Documents/digidog/leaderboard.txt";
        String USER_HOME = System.getProperty("user.home") != null ? System.getProperty("user.home") : "";
        return Paths.get(USER_HOME + USER_DIR_SUBPATH, new String[0]);
    }

    public LeaderBoardManager(Path highscoreDbPath) {
        this.highscoreDbPath = highscoreDbPath;
    }

    public Path getDbPath() {
        return this.highscoreDbPath;
    }

    public synchronized Map<String, Integer> getBoard() {
        return this.board;
    }

    public synchronized void recordWin(User player, int turns) {
        if (player == null || player.getNickname() == null || player.getNickname().trim().isEmpty()) {
            errorLogger.warn("Attempted to record win for invalid user.");
            return;
        }
        this.board.merge(player.getNickname(), turns, Integer::min);
        errorLogger.info("Recorded win for {}: {} turns. New best: {}", (Object)player.getNickname(), (Object)turns, (Object)this.board.get(player.getNickname()));
        this.saveToFile();
    }

    public synchronized void createHighscoreDatabaseIfNotExisting() {
        if (!Files.exists(this.getDbPath(), new LinkOption[0]) && !Files.isDirectory(this.highscoreDbPath, new LinkOption[0])) {
            try {
                Files.createFile(this.getDbPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                errorLogger.error("Could not create highscore database file: {}", (Object)e.getMessage());
            }
        } else {
            errorLogger.info("Highscore database file already exists.");
        }
    }

    public synchronized void loadFromFile() {
        InputStream inputStream = null;
        String loadedFromPathDescription = "N/A";
        errorLogger.debug("Checking for leaderboard in user directory: {}", (Object)this.getDbPath());
        try {
            if (Files.exists(this.getDbPath(), new LinkOption[0]) && Files.isReadable(this.getDbPath())) {
                inputStream = Files.newInputStream(this.getDbPath(), new OpenOption[0]);
                loadedFromPathDescription = this.getDbPath().toString();
                errorLogger.info("Found leaderboard file in user directory. Loading from: {}", (Object)loadedFromPathDescription);
            } else {
                errorLogger.info("Leaderboard file not found or not readable in user directory: {}", (Object)this.getDbPath());
            }
        }
        catch (IOException | SecurityException e) {
            errorLogger.warn("Could not access user leaderboard file at {}: {}", (Object)this.getDbPath(), (Object)e.getMessage());
        }
        if (inputStream != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line;
                int count = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    String[] parts = line.split(",", 2);
                    if (parts.length == 2) {
                        try {
                            String nickname = parts[0].trim();
                            int turns = Integer.parseInt(parts[1].trim());
                            if (!nickname.isEmpty()) {
                                this.board.merge(nickname, turns, Integer::min);
                                ++count;
                                continue;
                            }
                            errorLogger.warn("Skipping entry with empty nickname in line: {}", (Object)line);
                        }
                        catch (NumberFormatException e) {
                            errorLogger.warn("Skipping entry with invalid number format (score) in line: {}", (Object)line);
                        }
                        continue;
                    }
                    errorLogger.warn("Skipping entry with invalid format (expected 'nickname,score') in line: {}", (Object)line);
                }
                errorLogger.info("Successfully loaded {} entries from {}", (Object)count, (Object)loadedFromPathDescription);
            }
            catch (IOException e) {
                errorLogger.error("Error reading leaderboard data from {}: {}", (Object)loadedFromPathDescription, (Object)e.getMessage(), (Object)e);
            }
        } else {
            errorLogger.info("No leaderboard file found in specified user directory or internal resources. Starting with an empty board.");
        }
    }

    public synchronized void saveToFile() {
        boolean savedSuccessfully = false;
        errorLogger.info("Falling back to save leaderboard to user directory: {}", (Object)this.getDbPath());
        try {
            Path parentDir = this.getDbPath().getParent();
            if (parentDir != null) {
                Files.createDirectories(parentDir, new FileAttribute[0]);
                errorLogger.debug("Ensured directory exists: {}", (Object)parentDir);
            }
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(this.getDbPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
                this.writeBoardData(writer);
                errorLogger.info("Successfully saved {} entries to leaderboard file: {}", (Object)this.board.size(), (Object)this.getDbPath());
                savedSuccessfully = true;
            }
        }
        catch (IOException | SecurityException e) {
            errorLogger.error("CRITICAL: Failed to save leaderboard to fallback user directory {}: {}", (Object)this.getDbPath(), (Object)e.getMessage(), (Object)e);
        }
        catch (Exception e) {
            errorLogger.error("CRITICAL: Unexpected error during attempt to save to user directory {}: {}", (Object)this.getDbPath(), (Object)e.getMessage(), (Object)e);
        }
        if (!savedSuccessfully) {
            errorLogger.error("ALERT: Leaderboard data could NOT be saved to ANY location!");
        }
    }

    private void writeBoardData(PrintWriter writer) {
        for (Map.Entry<String, Integer> entry : this.board.entrySet()) {
            writer.println(entry.getKey() + "," + String.valueOf(entry.getValue()));
        }
    }
}

