/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.server.GameStateSender;
import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class LobbyActivatorThread
implements Runnable {
    private final ConcurrentHashMap<Integer, Game> games;
    private final ConcurrentHashMap<String, Integer> loggedInUsers;
    private final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;

    public LobbyActivatorThread(ConcurrentHashMap<Integer, Game> games, ConcurrentHashMap<String, Integer> loggedInUsers, ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues) {
        this.games = games;
        this.loggedInUsers = loggedInUsers;
        this.userQueues = userQueues;
    }

    @Override
    public void run() {
        block2: while (true) {
            Iterator<Game> iterator = this.games.values().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                Game game = iterator.next();
                if (game.numberOfPlayers() != 4 || game.isActive()) continue;
                game.startGame();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                GameStateSender.sendGameStateToLobby(game, this.loggedInUsers, this.userQueues);
            }
            break;
        }
    }
}

