/*
 * Decompiled with CFR 0.152.
 */
package ch.unibas.dmi.dbis.cs108.example.server;

import ch.unibas.dmi.dbis.cs108.example.gameLogic.Game;
import ch.unibas.dmi.dbis.cs108.example.protocol.Protocol;
import ch.unibas.dmi.dbis.cs108.example.server.ClientInfos;
import ch.unibas.dmi.dbis.cs108.example.server.GameServer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;

public class LobbyInfoDispatcherThread
implements Runnable {
    private final ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues;
    private final ConcurrentHashMap<Integer, ClientInfos> clients;
    private final ConcurrentHashMap<Integer, Game> games;

    LobbyInfoDispatcherThread(ConcurrentHashMap<Integer, BlockingQueue<String>> userQueues, ConcurrentHashMap<Integer, ClientInfos> clients, ConcurrentHashMap<Integer, Game> games) {
        this.userQueues = userQueues;
        this.clients = clients;
        this.games = games;
    }

    @Override
    public void run() {
        Protocol p = new Protocol();
        while (true) {
            if (this.games.isEmpty()) {
                continue;
            }
            for (Integer clientPort : this.clients.keySet()) {
                try {
                    this.userQueues.get(clientPort).put(p.encodeLobbyInfoGiver(GameServer.getLobbyInfoArray()));
                }
                catch (InterruptedException e) {
                    System.out.println("No players were found");
                }
            }
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (InterruptedException e) {
                System.out.println("Sleep interrupted");
                continue;
            }
            break;
        }
    }
}

