/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.NodeHelper;
import com.sun.javafx.scene.control.inputmap.InputMap;
import com.sun.javafx.scene.control.inputmap.KeyBinding;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalMethod;
import java.util.List;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class FocusTraversalInputMap<N extends Node> {
    private static final List<InputMap.Mapping<?>> MAPPINGS = List.of(new InputMap.KeyMapping(KeyCode.UP, keyEvent -> FocusTraversalInputMap.traverseUp(keyEvent)), new InputMap.KeyMapping(KeyCode.DOWN, keyEvent -> FocusTraversalInputMap.traverseDown(keyEvent)), new InputMap.KeyMapping(KeyCode.LEFT, keyEvent -> FocusTraversalInputMap.traverseLeft(keyEvent)), new InputMap.KeyMapping(KeyCode.RIGHT, keyEvent -> FocusTraversalInputMap.traverseRight(keyEvent)), new InputMap.KeyMapping(KeyCode.TAB, keyEvent -> FocusTraversalInputMap.traverseNext(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.TAB).shift(), keyEvent -> FocusTraversalInputMap.traversePrevious(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.UP).shift().alt().ctrl(), keyEvent -> FocusTraversalInputMap.traverseUp(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.DOWN).shift().alt().ctrl(), keyEvent -> FocusTraversalInputMap.traverseDown(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.LEFT).shift().alt().ctrl(), keyEvent -> FocusTraversalInputMap.traverseLeft(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.RIGHT).shift().alt().ctrl(), keyEvent -> FocusTraversalInputMap.traverseRight(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.TAB).shift().alt().ctrl(), keyEvent -> FocusTraversalInputMap.traverseNext(keyEvent)), new InputMap.KeyMapping(new KeyBinding(KeyCode.TAB).alt().ctrl(), keyEvent -> FocusTraversalInputMap.traversePrevious(keyEvent)));

    private FocusTraversalInputMap() {
    }

    public static InputMap.Mapping<?>[] getFocusTraversalMappings() {
        return MAPPINGS.toArray(new InputMap.Mapping[MAPPINGS.size()]);
    }

    public static <N extends Node> InputMap<N> createInputMap(N n) {
        InputMap<N> inputMap = new InputMap<N>(n);
        inputMap.getMappings().addAll(FocusTraversalInputMap.getFocusTraversalMappings());
        return inputMap;
    }

    public static void traverse(Node node, Direction direction, TraversalMethod traversalMethod) {
        if (node == null) {
            throw new IllegalArgumentException("Attempting to traverse on a null Node. Most probably a KeyEvent has been fired with a null target specified.");
        }
        NodeHelper.traverse(node, direction, traversalMethod);
    }

    public static final void traverseUp(KeyEvent keyEvent) {
        FocusTraversalInputMap.traverse(FocusTraversalInputMap.getNode(keyEvent), Direction.UP, TraversalMethod.KEY);
    }

    public static final void traverseDown(KeyEvent keyEvent) {
        FocusTraversalInputMap.traverse(FocusTraversalInputMap.getNode(keyEvent), Direction.DOWN, TraversalMethod.KEY);
    }

    public static final void traverseLeft(KeyEvent keyEvent) {
        FocusTraversalInputMap.traverse(FocusTraversalInputMap.getNode(keyEvent), Direction.LEFT, TraversalMethod.KEY);
    }

    public static final void traverseRight(KeyEvent keyEvent) {
        FocusTraversalInputMap.traverse(FocusTraversalInputMap.getNode(keyEvent), Direction.RIGHT, TraversalMethod.KEY);
    }

    public static final void traverseNext(KeyEvent keyEvent) {
        FocusTraversalInputMap.traverse(FocusTraversalInputMap.getNode(keyEvent), Direction.NEXT, TraversalMethod.KEY);
    }

    public static final void traversePrevious(KeyEvent keyEvent) {
        FocusTraversalInputMap.traverse(FocusTraversalInputMap.getNode(keyEvent), Direction.PREVIOUS, TraversalMethod.KEY);
    }

    private static Node getNode(KeyEvent keyEvent) {
        EventTarget eventTarget = keyEvent.getTarget();
        if (eventTarget instanceof Node) {
            return (Node)eventTarget;
        }
        return null;
    }
}

